/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jface.text.Position;

public abstract class SemanticReferenceRequestor
implements ITypeRequestor {
    protected static Position getPosition(ASTNode node) {
        int length;
        int offset;
        if (node instanceof ClassNode && ((ClassNode)node).getNameEnd() > 0 || node instanceof FieldNode || node instanceof MethodNode || node instanceof PropertyNode || node instanceof ConstructorCallExpression || node instanceof StaticMethodCallExpression || node instanceof Parameter) {
            AnnotatedNode an = (AnnotatedNode)node;
            offset = an.getNameStart();
            length = an.getNameEnd() - offset + 1;
        } else if (node instanceof MethodCallExpression) {
            Expression e = ((MethodCallExpression)node).getMethod();
            offset = e.getStart();
            length = e.getLength();
        } else {
            offset = node.getStart();
            length = node.getLength();
        }
        return new Position(offset, length);
    }

    protected static boolean isFinal(ASTNode node) {
        if (node instanceof FieldNode) {
            return ((FieldNode)node).isFinal();
        }
        if (node instanceof MethodNode) {
            return ((MethodNode)node).isFinal();
        }
        if (node instanceof PropertyNode) {
            return ((PropertyNode)node).getField().isFinal();
        }
        return false;
    }

    protected static boolean isForLoopParam(Variable param, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupName(param.getName());
        return info != null && info.scopeNode instanceof ForStatement;
    }

    protected static boolean isCatchParam(Variable param, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupName(param.getName());
        return info != null && info.scopeNode instanceof CatchStatement;
    }

    protected static boolean isNumber(ClassNode type) {
        return ClassHelper.isNumberType((ClassNode)type) || ClassHelper.BigDecimal_TYPE.equals((Object)type) || ClassHelper.BigInteger_TYPE.equals((Object)type);
    }

    protected static boolean isStatic(ASTNode node) {
        if (node instanceof FieldNode) {
            return ((FieldNode)node).isStatic();
        }
        if (node instanceof MethodNode) {
            return ((MethodNode)node).isStatic();
        }
        if (node instanceof PropertyNode) {
            return ((PropertyNode)node).isStatic();
        }
        return false;
    }
}

