/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.outline.GroovyOutlinePage;
import org.codehaus.groovy.eclipse.editor.outline.GroovyScriptOutlineExtender;
import org.codehaus.groovy.eclipse.editor.outline.IOutlineExtender;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class OutlineExtenderRegistry {
    public static final String EXTENSION_POINT = "org.codehaus.groovy.eclipse.ui.outlineExtension";
    public static final String NATURE_ID = "natureID";
    public static final String EXTENDER = "extender";
    Map<String, List<IOutlineExtender>> natureToExtenderMap;
    GroovyScriptOutlineExtender groovyScriptExtender;

    public void initialize() throws CoreException {
        IExtension[] extensions;
        this.natureToExtenderMap = new HashMap<String, List<IOutlineExtender>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElts;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElts = ext.getConfigurationElements();
            int n3 = configElts.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elt = iConfigurationElementArray[n4];
                String natureID = elt.getAttribute(NATURE_ID);
                Object object = WorkbenchPlugin.createExtension((IConfigurationElement)elt, (String)EXTENDER);
                if (object instanceof IOutlineExtender) {
                    List<IOutlineExtender> extenders = this.natureToExtenderMap.get(natureID);
                    if (extenders == null) {
                        extenders = new ArrayList<IOutlineExtender>(1);
                        this.natureToExtenderMap.put(natureID, extenders);
                    }
                    extenders.add((IOutlineExtender)object);
                }
                ++n4;
            }
            ++n2;
        }
        this.groovyScriptExtender = new GroovyScriptOutlineExtender();
    }

    public List<IOutlineExtender> getExtenders(String natureID) {
        return this.natureToExtenderMap.get(natureID);
    }

    public GroovyOutlinePage getGroovyOutlinePageForEditor(IProject project, String contextMenuID, GroovyEditor editor) throws CoreException {
        String[] natureIds;
        if (project == null || !project.isAccessible()) {
            return null;
        }
        GroovyOutlinePage groovyOutlinePage = null;
        String[] stringArray = natureIds = project.getDescription().getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        block0: while (n2 < n) {
            String natureId = stringArray[n2];
            List<IOutlineExtender> extenders = this.getExtenders(natureId);
            if (extenders != null) {
                for (IOutlineExtender extender : extenders) {
                    GroovyOutlinePage page;
                    if (!extender.appliesTo(editor.getGroovyCompilationUnit()) || (page = extender.getGroovyOutlinePageForEditor(contextMenuID, editor)) == null) continue;
                    groovyOutlinePage = page;
                    break block0;
                }
            }
            ++n2;
        }
        if (groovyOutlinePage != null) {
            return groovyOutlinePage;
        }
        if (this.groovyScriptExtender.appliesTo(editor.getGroovyCompilationUnit())) {
            return this.groovyScriptExtender.getGroovyOutlinePageForEditor(contextMenuID, editor);
        }
        return null;
    }
}

