/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractGroovyCleanUp
extends AbstractCleanUp {
    protected RefactoringStatus status;

    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus stat = new RefactoringStatus();
        try {
            ICompilationUnit[] iCompilationUnitArray = compilationUnits;
            int n = compilationUnits.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                if (!(unit instanceof GroovyCompilationUnit)) {
                    stat.addError("Cannot use cleanup on a non-groovy compilation unit: " + unit.getElementName());
                } else if (((GroovyCompilationUnit)unit).getModuleNode() == null) {
                    stat.addError("Cannot find module node for compilation unit: " + unit.getElementName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Cannot perform cleanup.", (Throwable)e);
            stat.addFatalError("Cannot perform cleanup. See error log. " + e.getMessage());
        }
        return stat;
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.status == null || this.status.isOK()) {
                RefactoringStatus refactoringStatus = super.checkPostConditions(monitor);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = this.status;
            return refactoringStatus;
        }
        finally {
            this.status = null;
        }
    }
}

