/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.refactoring.actions.AbstractGroovyCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.CleanUpPostSaveListener;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyCodeFormatCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyImportsCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.TrailingWhitespacesCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.UnnecessarySemicolonsCleanUp;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.preference.IPreferenceStore;

public class GroovyCleanUpPostSaveListener
extends CleanUpPostSaveListener
implements IPostSaveListener {
    @Override
    protected ICleanUp[] getCleanUps(Map<String, String> settings, Set<String> ids) {
        MapCleanUpOptions options = new MapCleanUpOptions(settings);
        boolean doImports = false;
        boolean doFormat = false;
        boolean doIndent = false;
        IPreferenceStore groovyPreferences = GroovyPlugin.getDefault().getPreferenceStore();
        boolean doSemicolonRemoval = groovyPreferences.getBoolean("groovy.SaveAction.RemoveUnnecessarySemicolons");
        boolean doWhitespaceRemoval = options.isEnabled("cleanup.remove_trailing_whitespaces");
        ICleanUp[] iCleanUpArray = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps(ids);
        int n = iCleanUpArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICleanUp cleanup = iCleanUpArray[n2];
            if (cleanup instanceof ImportsCleanUp && options.isEnabled("cleanup.organize_imports")) {
                doImports = true;
            } else if (cleanup instanceof CodeFormatCleanUp) {
                if (options.isEnabled("cleanup.format_source_code")) {
                    doFormat = true;
                } else if (options.isEnabled("cleanup.correct_indentation")) {
                    doIndent = true;
                }
            }
            ++n2;
        }
        ArrayList<AbstractGroovyCleanUp> groovyCleanUps = new ArrayList<AbstractGroovyCleanUp>(4);
        if (doImports) {
            groovyCleanUps.add(new GroovyImportsCleanUp());
        }
        if (doFormat) {
            groovyCleanUps.add(new GroovyCodeFormatCleanUp(FormatKind.FORMAT));
        } else if (doIndent) {
            groovyCleanUps.add(new GroovyCodeFormatCleanUp(FormatKind.INDENT_ONLY));
        }
        if (doSemicolonRemoval) {
            groovyCleanUps.add(new UnnecessarySemicolonsCleanUp());
        }
        if (doWhitespaceRemoval) {
            groovyCleanUps.add(new TrailingWhitespacesCleanUp());
        }
        return groovyCleanUps.toArray(new ICleanUp[groovyCleanUps.size()]);
    }
}

