/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class GroovyRefactoringAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private GroovyEditor editor;
    private ITextSelection selection;
    private GroovyCompilationUnit groovyUnit;

    protected boolean checkPreconditions() {
        if (this.editor != null && this.selection != null && this.groovyUnit != null) {
            if (this.groovyUnit.getModuleNode() != null) {
                return true;
            }
            this.displayErrorDialog("Cannot find ModuleNode for " + this.groovyUnit.getElementName());
        }
        return false;
    }

    protected void displayErrorDialog(String message) {
        ErrorDialog error = new ErrorDialog(this.editor.getSite().getShell(), "Groovy Refactoring error", message, (IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", message), 6);
        error.open();
    }

    public void dispose() {
        this.editor = null;
        this.selection = null;
        this.groovyUnit = null;
    }

    protected final IDocument getDocument() {
        return this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
    }

    protected final GroovyEditor getEditor() {
        return this.editor;
    }

    protected final ITextSelection getSelection() {
        return this.selection;
    }

    protected final GroovyCompilationUnit getUnit() {
        return this.groovyUnit;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof ITextSelection ? (ITextSelection)selection : null;
        this.updateEnabled(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof GroovyEditor) {
            this.editor = (GroovyEditor)targetEditor;
            this.groovyUnit = this.editor.getGroovyCompilationUnit();
        } else {
            this.editor = null;
            this.groovyUnit = null;
        }
        this.updateEnabled(action);
    }

    private void updateEnabled(IAction action) {
        action.setEnabled(this.editor != null && this.selection != null && this.groovyUnit != null);
    }
}

