/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.browse;

import org.codehaus.groovy.eclipse.ui.browse.IBrowseTypeHandler;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TypeBrowseSupport {
    private IJavaProject project;
    public static final int FLAG_INTERFACE = 4;
    public static final int FLAG_CLASS = 8;
    public static final String TITLE = "Browse for Type";
    public static final String MESSAGE = "Browse and select a type";
    private Shell shell;
    private IBrowseTypeHandler handler;

    public TypeBrowseSupport(Shell shell, IJavaProject project, IBrowseTypeHandler handler) {
        this.shell = shell;
        this.project = project;
        this.handler = handler;
    }

    protected IJavaProject getJavaProject() {
        return this.project;
    }

    protected boolean isShellValid() {
        return this.shell != null && !this.shell.isDisposed();
    }

    protected void browseButtonPressed(Text text) {
        IType type;
        if (!this.isShellValid()) {
            return;
        }
        String pattern = text != null && !text.isDisposed() ? text.getText() : null;
        int javaSearchType = TypeBrowseSupport.getJavaSearchType();
        if (javaSearchType == -1) {
            return;
        }
        IJavaElement[] elements = new IJavaElement[]{this.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.shell, false, null, scope, javaSearchType);
        dialog.setTitle(TITLE);
        dialog.setMessage(MESSAGE);
        dialog.setInitialPattern(pattern);
        Text finText = text;
        if (dialog.open() == 0 && (type = (IType)dialog.getFirstResult()) != null) {
            String qualifiedName = type.getFullyQualifiedName();
            finText.setText(qualifiedName);
            if (this.handler != null) {
                this.handler.handleTypeSelection(finText.getText());
            }
        }
    }

    public void applySupport(Button button, Text text) {
        final Text finText = text;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeBrowseSupport.this.browseButtonPressed(finText);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TypeBrowseSupport.this.browseButtonPressed(finText);
            }
        });
    }

    public static int getJavaSearchType() {
        return 0;
    }
}

