/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.console;

import java.util.Arrays;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.ui.console.GroovyConsolePage;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class GroovyConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "GroovyEventTraceConsole";
    private static final RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
    private IConsoleDocumentPartitioner partitioner = new GroovyEventTraceConsolePartitioner();
    private IPropertyChangeListener propertyListener = event -> {
        String property = event.getProperty();
        if (property.equals("org.eclipse.debug.ui.consoleFont")) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        }
    };

    static {
        scanner.setPredicateRules((IPredicateRule[])Arrays.stream(TraceCategory.values()).map(category -> new SingleLineRule(category.getPaddedLabel(), "", (IToken)new Token((Object)category.label))).toArray(IPredicateRule[]::new));
    }

    public GroovyConsole() {
        super("Groovy Event Trace Console", CONSOLE_TYPE, null, true);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        this.partitioner.connect(this.getDocument());
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new GroovyConsolePage(this, view);
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    private class GroovyEventTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        GroovyEventTraceConsolePartitioner() {
            super((IPartitionTokenScanner)scanner, TraceCategory.stringValues());
            GroovyConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return true;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            return (StyleRange[])Arrays.stream(this.computePartitioning(offset, length)).map(ITypedRegion::getType).map(type -> {
                Color color = type.equals(TraceCategory.CLASSPATH.label) ? registry.get("ERROR_COLOR") : (type.equals(TraceCategory.COMPILER.label) || type.equals(TraceCategory.AST_TRANSFORM.label) ? registry.get("COUNTER_COLOR") : (type.equals(TraceCategory.CODE_SELECT.label) || type.equals(TraceCategory.CONTENT_ASSIST.label) ? registry.get("DECORATIONS_COLOR") : (type.equals(TraceCategory.DSL.label) ? Display.getDefault().getSystemColor(11) : registry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"))));
                return new StyleRange(offset, length, color, null);
            }).toArray(StyleRange[]::new);
        }
    }
}

