/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.codehaus.groovy.eclipse.wizards.WizardMessages;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.wizards.NewTestCaseCreationWizard;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class NewTestWizard
extends NewTestCaseCreationWizard {
    public NewTestWizard() {
        this.setWindowTitle(WizardMessages.NewTestWizard_title);
    }

    public void addPages() {
        NewTestCaseWizardPageTwo pageTwo = new NewTestCaseWizardPageTwo();
        PageOne pageOne = new PageOne(pageTwo);
        pageOne.init(this.getSelection());
        this.addPage((IWizardPage)pageOne);
        this.addPage((IWizardPage)pageTwo);
        ReflectionUtils.setPrivateField(NewTestCaseCreationWizard.class, (String)"fPage1", (Object)((Object)this), (Object)((Object)pageOne));
        ReflectionUtils.setPrivateField(NewTestCaseCreationWizard.class, (String)"fPage2", (Object)((Object)this), (Object)pageTwo);
    }

    public static class PageOne
    extends NewTestCaseWizardPageOne {
        private IType maybeCreatedType;

        public PageOne(NewTestCaseWizardPageTwo pageTwo) {
            super(pageTwo);
        }

        public IType getCreatedType() {
            return this.maybeCreatedType != null ? this.maybeCreatedType : super.getCreatedType();
        }

        protected String getCompilationUnitName(String typeName) {
            return typeName + ".groovy";
        }

        protected String getJUnit3TestSuperclassName() {
            return "groovy.util.GroovyTestCase";
        }

        protected boolean hasGroovyNature() {
            IProject project = this.getProject();
            if (project != null) {
                return GroovyNature.hasGroovyNature((IProject)project);
            }
            return false;
        }

        protected IProject getProject() {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject == null) {
                return null;
            }
            return javaProject.getProject();
        }

        protected IStatus superClassChanged() {
            if (this.getJUnitVersion() == NewTestCaseWizardPageOne.JUnitVersion.VERSION_4) {
                return super.superClassChanged();
            }
            String superClassName = this.getSuperClass();
            if (this.getJUnit3TestSuperclassName().equals(superClassName)) {
                return new JUnitStatus();
            }
            return super.superClassChanged();
        }

        public int getModifiers() {
            int modifiers = super.getModifiers();
            return modifiers & ~(this.F_PUBLIC | this.F_PRIVATE | this.F_PROTECTED);
        }

        protected void updateStatus(IStatus status) {
            if (!this.hasGroovyNature()) {
                super.updateStatus((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", "Project is not a Groovy Project. Please select a Groovy project."));
                return;
            }
            super.updateStatus(status);
        }

        public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
            GroovyCompilationUnit unit;
            if (!this.hasGroovyNature()) {
                GroovyCore.logWarning((String)"Project is not a Groovy Project. Please select a Groovy project.");
                return;
            }
            SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
            String name = this.getTypeName();
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                pack = this.getPackageFragmentRoot().getPackageFragment("");
            }
            if (this.getJUnitVersion() == NewTestCaseWizardPageOne.JUnitVersion.VERSION_3 && this.getPackageFragment().getElementName().equals("")) {
                String newline = pack.findRecommendedLineSeparator();
                StringBuilder source = new StringBuilder();
                String superClass = this.getSuperClass();
                String[] tokens = superClass.split("\\.");
                if (tokens.length > 1) {
                    source.append("import ").append(superClass).append(newline).append(newline);
                }
                source.append("class ").append(name).append(" extends ").append(tokens[tokens.length - 1]);
                source.append(" {").append(newline);
                source.append(newline).append("}").append(newline);
                unit = (GroovyCompilationUnit)pack.createCompilationUnit(this.getCompilationUnitName(name), source.toString(), true, (IProgressMonitor)submon.split(1));
                this.maybeCreatedType = unit.getType(name);
            } else {
                super.createType((IProgressMonitor)submon.split(1));
                unit = (GroovyCompilationUnit)pack.getCompilationUnit(this.getCompilationUnitName(name));
            }
            try {
                char[] contents = unit.getContents();
                unit.becomeWorkingCopy((IProgressMonitor)submon.split(1));
                MultiTextEdit textEdit = new MultiTextEdit();
                new SemicolonRemover((ITextSelection)new TextSelection(0, contents.length), (IDocument)new Document(String.valueOf(contents)), textEdit).format();
                submon.worked(1);
                if (textEdit.hasChildren()) {
                    unit.applyTextEdit((TextEdit)textEdit, (IProgressMonitor)submon.split(1));
                    unit.commitWorkingCopy(true, (IProgressMonitor)submon.split(1));
                }
            }
            finally {
                if (unit != null) {
                    unit.discardWorkingCopy();
                }
            }
        }
    }
}

