/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.windows;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.windows.driver.WindowsDriverType;
import com.kms.katalon.execution.configuration.AbstractDriverConnector;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WindowsDriverConnector
extends AbstractDriverConnector
implements IDriverConnector {
    private String configurationFolderPath;

    public WindowsDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        this.configurationFolderPath = configurationFolderPath;
    }

    public IDriverType getDriverType() {
        return WindowsDriverType.getInstance();
    }

    public String getSettingFileName() {
        return "com.kms.katalon.core.windows";
    }

    public WindowsDriverConnector clone() {
        try {
            WindowsDriverConnector clone = new WindowsDriverConnector(this.configurationFolderPath);
            Map cloneProperties = clone.getUserConfigProperties();
            Object driverUrl = this.driverProperties.get("desktopDriverUrl");
            if (driverUrl != null) {
                cloneProperties.put("desktopDriverUrl", driverUrl);
            }
            if (this.driverProperties.containsKey("desiredCapabilities")) {
                cloneProperties.put("desiredCapabilities", this.getDesiredCapabilities());
            }
            return clone;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getDesiredCapabilities() {
        Map userProperties = this.getUserConfigProperties();
        if (userProperties.containsKey("desiredCapabilities")) {
            return (Map)userProperties.get("desiredCapabilities");
        }
        return new LinkedHashMap<String, Object>();
    }

    protected void loadDriverProperties() throws IOException {
        String legacyWinAppDriverUrl;
        super.loadDriverProperties();
        String flaUIDriverUrl = (String)this.driverProperties.get("desktopDriverUrl");
        if (StringUtils.isBlank((CharSequence)flaUIDriverUrl) && !StringUtils.isBlank((CharSequence)(legacyWinAppDriverUrl = (String)this.driverProperties.get("winAppDriverUrl")))) {
            this.driverProperties.put("desktopDriverUrl", legacyWinAppDriverUrl);
        }
    }

    public String getDriverUrl() {
        return (String)this.getUserConfigProperties().get("desktopDriverUrl");
    }

    public void setDriverUrl(String driverUrl) {
        this.driverProperties.put("desktopDriverUrl", driverUrl);
    }

    public static WindowsDriverConnector getInstance(String projectDir) throws IOException {
        return new WindowsDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
    }

    public Map<String, Object> getAllConfigProperties() {
        LinkedHashMap<String, Object> allConfigProperties = new LinkedHashMap<String, Object>();
        allConfigProperties.putAll(this.getDesiredCapabilities());
        String driverUrl = this.getDriverUrl();
        if (StringUtils.isNotBlank((CharSequence)driverUrl)) {
            allConfigProperties.put("desktopDriverUrl", driverUrl);
        }
        return allConfigProperties;
    }

    public void setAllConfigProperties(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        LinkedHashMap<String, Object> windowsConfigProperties = new LinkedHashMap<String, Object>();
        Object driverUrl = properties.get("desktopDriverUrl");
        if (driverUrl != null) {
            windowsConfigProperties.put("desktopDriverUrl", driverUrl);
        }
        properties.remove("winAppDriverUrl");
        properties.remove("desktopDriverUrl");
        if (!properties.isEmpty()) {
            windowsConfigProperties.put("desiredCapabilities", properties);
        }
        this.driverProperties = windowsConfigProperties;
    }
}

