/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model;

import com.kms.katalon.ai.core.constant.MessageConstants;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatQuestionMessage;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.util.ToolUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StudioAssistChatAnswerMessageFuture
extends Thread
implements Future<ResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatAnswerMessageFuture.class);
    protected ResponseMessage result = null;
    protected StudioAssistChatQuestionMessage question;
    protected List<LlmMessage> messages;
    protected Map<String, List<McpSchema.Tool>> availableTools;
    protected AtomicReference<Throwable> lastExecutionException = new AtomicReference();
    protected Consumer<ResponseMessage> callback;
    protected Consumer<Throwable> exceptionCallback;

    public StudioAssistChatAnswerMessageFuture(List<LlmMessage> messages, StudioAssistChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools) {
        this.messages = messages;
        this.question = question;
        this.availableTools = Objects.requireNonNullElseGet(availableTools, Map::of);
        this.setUncaughtExceptionHandler((t, e) -> {
            this.lastExecutionException.set(e);
            if (this.exceptionCallback != null) {
                this.exceptionCallback.accept(e);
            }
        });
    }

    public void setCallback(Consumer<ResponseMessage> callback) {
        this.callback = callback;
    }

    public void setExceptionCallback(Consumer<Throwable> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
    }

    protected StudioAssistChatQuestionMessage getQuestion() {
        return this.question;
    }

    protected void setResult(ResponseMessage result) {
        this.result = result;
        if (this.callback != null) {
            this.callback.accept(result);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.interrupt();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isInterrupted();
    }

    @Override
    public boolean isDone() {
        return this.getState() != Thread.State.NEW && !this.isAlive();
    }

    @Override
    public ResponseMessage get() throws InterruptedException, ExecutionException {
        ResponseMessage answerMessage;
        try {
            answerMessage = this.get(0L, null);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
        return answerMessage;
    }

    @Override
    public ResponseMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable t;
        if (!this.isDone()) {
            if (Objects.nonNull((Object)unit)) {
                this.join(unit.toMillis(timeout));
                if (!this.isDone()) {
                    throw new TimeoutException("Timeout exceeded while getting the result.");
                }
            } else {
                this.join();
            }
        }
        if (Objects.nonNull(t = this.lastExecutionException.get())) {
            if (t instanceof StudioAssistLlmApiRuntimeException) {
                StudioAssistLlmApiRuntimeException re = (StudioAssistLlmApiRuntimeException)t;
                throw re;
            }
            throw new ExecutionException(t);
        }
        return this.result;
    }

    public String getConversationId() {
        return this.question == null ? "" : this.question.getConversationId();
    }

    public String getMessageId() {
        return this.question == null ? "" : this.question.getQuestionMsgId();
    }

    protected List<McpSchema.Tool> getLlmTools() {
        return this.availableTools.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(tool -> McpSchema.Tool.builder().name(ToolUtil.formatLlmToolName((String)entry.getKey(), tool.name())).description(tool.description()).inputSchema(tool.inputSchema()).outputSchema(tool.outputSchema()).build())).toList();
    }

    protected McpSchema.Tool getToolFromServerNameAndToolName(String mcpServerName, String toolName) {
        return this.availableTools.entrySet().stream().filter(entry -> StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)mcpServerName)).flatMap(entry -> ((List)entry.getValue()).stream()).filter(tool -> StringUtils.equals((CharSequence)toolName, (CharSequence)tool.name())).findFirst().orElse(null);
    }

    protected ResponseMessage mapFromAssistantMessage(AssistantMessage assistantMessage) {
        String assistantAnswer = assistantMessage.getContent();
        if (StringUtils.isNotEmpty((CharSequence)assistantAnswer)) {
            StudioAssistChatAnswerMessage answer = new StudioAssistChatAnswerMessage();
            try {
                StudioAssistChatAnswerMessage chatAnswerMessage = (StudioAssistChatAnswerMessage)JsonUtil.fromJson((String)assistantAnswer, StudioAssistChatAnswerMessage.class);
                if (StringUtils.isNotEmpty((CharSequence)chatAnswerMessage.getFinalAnswer())) {
                    answer.setFinalAnswer(chatAnswerMessage.getFinalAnswer());
                } else {
                    answer.setFinalAnswer(MessageConstants.STUDIO_ASSIST_INLINE_SCOPE_VIOLATION_ERROR_MSG);
                }
            }
            catch (Exception exception) {
                answer.setFinalAnswer(assistantAnswer);
            }
            return answer;
        }
        List<ResponseMessage> toolCalls = assistantMessage.getToolCalls().stream().map(this::mapToToolCallMessage).filter(Objects::nonNull).map(toolCallMessage -> toolCallMessage).toList();
        AgentMessage agentMessage = new AgentMessage(this.getMessageId(), this.getConversationId());
        agentMessage.setChildren(toolCalls);
        return agentMessage;
    }

    private ToolCallMessage mapToToolCallMessage(ToolCall toolCall) {
        String toolName;
        String toolCallName = toolCall.getName();
        String serverName = ToolUtil.parseServerNameFromToolCall(toolCallName);
        McpSchema.Tool foundTool = this.getToolFromServerNameAndToolName(serverName, toolName = ToolUtil.parseToolNameFromToolCall(toolCallName));
        if (foundTool == null) {
            this.logger.debug("Tool not found for tool call name: {} ", (Object)toolCallName);
            return null;
        }
        ToolCallMessage tool = new ToolCallMessage(foundTool);
        tool.setCallId(toolCall.getCallId());
        tool.setServer(serverName);
        tool.setStatus(ToolCallStatus.REQUESTED);
        tool.setInput(toolCall.getInput());
        return tool;
    }
}

