/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.chat;

import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistConversation {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistConversation.class);
    private String conversationId = UUID.randomUUID().toString();
    private ArrayBlockingQueue<StudioAssistChatItem> chatHistory;

    public StudioAssistConversation(int queueCapacity, boolean fair) {
        this.chatHistory = new ArrayBlockingQueue(queueCapacity, fair);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public ArrayBlockingQueue<StudioAssistChatItem> getChatHistory() {
        return this.chatHistory;
    }

    public String reset() {
        this.conversationId = UUID.randomUUID().toString();
        this.chatHistory.clear();
        return this.conversationId;
    }

    public void increaseQueueSize(int expandSize, boolean fair) {
        int currentQueueSize = this.chatHistory.size();
        this.chatHistory = new ArrayBlockingQueue<StudioAssistChatItem>(currentQueueSize + expandSize, fair, this.chatHistory);
        this.logger.debug("The chat history queue capacity is full %s, expand the queue to %s".formatted(currentQueueSize, this.chatHistory.size() + this.chatHistory.remainingCapacity()));
    }

    public boolean addChatItemIntoHistory(StudioAssistChatItem chatItem) {
        return this.chatHistory.add(chatItem);
    }

    public List<StudioAssistChatItem> getValidChatItems() {
        return this.chatHistory.stream().filter(StudioAssistChatItem::isValidForConversationHistory).collect(Collectors.toList());
    }
}

