/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.azure.constant.AzureMessagesConstants;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureAPIErrorMessage;
import com.kms.katalon.integration.azure.model.AzureAttachmentResponseBody;
import com.kms.katalon.integration.azure.model.AzureBuildRef;
import com.kms.katalon.integration.azure.model.AzureBuildsRef;
import com.kms.katalon.integration.azure.model.AzureCompleteTestRunBody;
import com.kms.katalon.integration.azure.model.AzureCreateTestRunBody;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureGetWorkItemsBatchReqBody;
import com.kms.katalon.integration.azure.model.AzureGetWorkItemsBatchResBody;
import com.kms.katalon.integration.azure.model.AzureProjectsRef;
import com.kms.katalon.integration.azure.model.AzureReleaseDefinitionRef;
import com.kms.katalon.integration.azure.model.AzureReleaseEnvironmentRef;
import com.kms.katalon.integration.azure.model.AzureReleaseRef;
import com.kms.katalon.integration.azure.model.AzureTestAttachment;
import com.kms.katalon.integration.azure.model.AzureTestCaseResult;
import com.kms.katalon.integration.azure.model.AzureTestCaseResultBody;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationsRef;
import com.kms.katalon.integration.azure.model.AzureTestPlansRef;
import com.kms.katalon.integration.azure.model.AzureTestPointList;
import com.kms.katalon.integration.azure.model.AzureTestRun;
import com.kms.katalon.integration.azure.model.AzureTestSuitesRef;
import com.kms.katalon.integration.azure.model.AzureUpdateWorkItemsBatchReqBodyItem;
import com.kms.katalon.integration.azure.model.AzureUpdateWorkItemsBatchResBody;
import com.kms.katalon.integration.azure.model.ShallowReference;
import com.kms.katalon.integration.azure.provider.AzureAPIProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class AzureIntegrationRequest {
    private static HttpOptions buildHttpOptions(AzureCredential credential) {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HashMap headers = new HashMap();
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)Authentication.BasicAuthentication((String)"", (String)credential.getToken())).proxy(proxyConfig).build();
        return httpOptions;
    }

    private static <T> T parseResponse(HttpResponse response, URI requestUri, Class<T> returnType) throws Exception {
        int statusCode = response.getStatusCode();
        String responseString = response.getBody();
        if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
            Gson gson = new GsonBuilder().create();
            return (T)gson.fromJson(responseString, returnType);
        }
        Gson gson = new GsonBuilder().create();
        try {
            AzureAPIErrorMessage exception = (AzureAPIErrorMessage)gson.fromJson(responseString, AzureAPIErrorMessage.class);
            if (exception != null && StringUtils.isNotEmpty((CharSequence)exception.getMessage())) {
                responseString = exception.getMessage();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            responseString = "";
        }
        if (StringUtils.isEmpty((CharSequence)responseString)) {
            switch (statusCode) {
                case 401: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_UNAUTHORIZED;
                    break;
                }
                case 404: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_NOT_FOUND;
                    break;
                }
                case 203: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_NON_AUTHORITATIVE_INFO;
                    break;
                }
                case 403: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_FORBIDDEN;
                }
            }
        }
        LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_AZURE_EXCEPTION, requestUri, statusCode, responseString));
        throw new AzureApiException(responseString);
    }

    public static AzureProjectsRef getProjects(AzureCredential credential) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getProjectsAPIUrl(credential));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            AzureProjectsRef unsortedResult = AzureIntegrationRequest.parseResponse(response, uri, AzureProjectsRef.class);
            return unsortedResult.sort();
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestSuitesRef getTestSuitesByTestCaseId(AzureCredential credential, int testCaseId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getTestSuitesByTestCaseIdAPIUrl(credential, testCaseId));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestSuitesRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestConfigurationsRef getAllTestConfigurations(AzureCredential credential, String projectId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getAllTestConfigurationsAPIUrl(credential, projectId, 0));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestConfigurationsRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestPointList getTestPointListByTestCase(AzureCredential credential, String projectId, int testPlanId, int testSuiteId, int testCaseId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getPointsAPIUrl(credential, projectId, testPlanId, testSuiteId, testCaseId));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestPointList.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestRun createTestRun(AzureCredential credential, String projectId, int buildNumber, String testRunName, String comment, int planId, int[] pointIds, AzureReleaseRef release) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getCreateTestRunAPIUrl(credential, projectId));
            AzureCreateTestRunBody testRunBody = new AzureCreateTestRunBody();
            testRunBody.setName(testRunName);
            testRunBody.setComment(comment);
            if (buildNumber >= 0) {
                testRunBody.setBuild(new ShallowReference(buildNumber));
            }
            testRunBody.setPlan(new ShallowReference(planId));
            testRunBody.setPointIds(pointIds);
            if (release != null) {
                testRunBody.setReleaseUri(release.getId());
                testRunBody.setReleaseEnvironmentUri(release.getInProgressEnvironmentId());
            }
            HttpResponse response = httpClient.jsonPost(uri, JsonUtil.toJson((Object)testRunBody), AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestRun.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestRun completeTestRun(AzureCredential credential, String projectId, AzureTestRun testRun) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestRunAPIUrl(credential, projectId, testRun.getId()));
            AzureCompleteTestRunBody completeTestRunBody = new AzureCompleteTestRunBody();
            completeTestRunBody.setState("Completed");
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)completeTestRunBody));
            HttpResponse response = httpClient.patch(uri, (HttpEntity)entity, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestRun.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestCaseResultBody getTestCaseResults(AzureCredential credential, String projectId, AzureTestRun testRun) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestCaseResultsAPIUrl(credential, projectId, testRun.getId()));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestCaseResultBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestCaseResultBody updateTestCaseResults(AzureCredential credential, String projectId, AzureTestRun testRun, AzureTestCaseResult[] requestBody) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestCaseResultsAPIUrl(credential, projectId, testRun.getId()));
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody));
            HttpResponse response = httpClient.patch(uri, (HttpEntity)entity, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureTestCaseResultBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureGetWorkItemsBatchResBody bulkRetrieveWorkItemsBatch(AzureCredential credential, AzureGetWorkItemsBatchReqBody requestBody) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getBulkRetrieveWorkItemsAPIUrl(credential));
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody, (boolean)true, (boolean)false, (boolean)true));
            HttpResponse response = httpClient.post(uri, (HttpEntity)entity, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureGetWorkItemsBatchResBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureUpdateWorkItemsBatchResBody bulkUpdateWorkItems(AzureCredential credential, AzureUpdateWorkItemsBatchReqBodyItem[] requestBody) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getBulkUpdateWorkItemsAPIUrl(credential));
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody, (boolean)true, (boolean)false, (boolean)true));
            HttpResponse response = httpClient.patch(uri, (HttpEntity)entity, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureUpdateWorkItemsBatchResBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureAttachmentResponseBody uploadAttachment(AzureCredential credential, String projectId, AzureTestRun testRun, AzureTestAttachment requestBody) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getUploadAttachmentAPIUrl(credential, projectId, testRun.getId()));
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody));
            HttpResponse response = httpClient.post(uri, (HttpEntity)entity, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureAttachmentResponseBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestPlansRef getAllTestPlans(AzureCredential credential, String projectId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getAllTestPlansAPIUrl(credential, projectId));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            AzureTestPlansRef unsortedTestPlans = AzureIntegrationRequest.parseResponse(response, uri, AzureTestPlansRef.class);
            return unsortedTestPlans.sort();
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static ShallowReference getBuildDefinition(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getBuildDefinitionAPIUrl(credential, projectId, definitionId));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, ShallowReference.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureBuildRef getLatestBuildNumber(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        AzureBuildsRef buildList;
        block3: {
            IHttpClient httpClient = ApacheHttpClient.getInstance();
            try {
                URI uri = new URI(AzureAPIProvider.getLatestBuildByDefinitionIdAPIUrl(credential, projectId, definitionId));
                HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
                buildList = AzureIntegrationRequest.parseResponse(response, uri, AzureBuildsRef.class);
                if (buildList != null && buildList.getCount() > 0) break block3;
                return null;
            }
            catch (Exception exception) {
                throw AzureApiException.wrap(exception);
            }
        }
        return buildList.sort().getValue()[0];
    }

    public static AzureReleaseDefinitionRef getReleaseDefinition(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(AzureAPIProvider.getReleaseDefinitionAPIUrl(credential, projectId, definitionId));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            return AzureIntegrationRequest.parseResponse(response, uri, AzureReleaseDefinitionRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureReleaseRef getLatestReleaseWithInProgressEnvironment(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        AzureReleaseRef release;
        block5: {
            IHttpClient httpClient = ApacheHttpClient.getInstance();
            AzureReleaseDefinitionRef releaseDefinition = AzureIntegrationRequest.getReleaseDefinition(credential, projectId, definitionId);
            AzureReleaseRef latestRelease = releaseDefinition.getLastRelease();
            URI uri = new URI(AzureAPIProvider.getReleaseAPIUrl(credential, projectId, latestRelease.getId()));
            HttpResponse response = httpClient.get(uri, AzureIntegrationRequest.buildHttpOptions(credential));
            release = AzureIntegrationRequest.parseResponse(response, uri, AzureReleaseRef.class);
            if (release != null) break block5;
            return null;
        }
        try {
            AzureReleaseEnvironmentRef[] environments;
            AzureReleaseEnvironmentRef[] azureReleaseEnvironmentRefArray = environments = release.getEnvironments();
            int n = environments.length;
            int n2 = 0;
            while (n2 < n) {
                AzureReleaseEnvironmentRef env = azureReleaseEnvironmentRefArray[n2];
                if (env.getStatus().equals("inProgress")) {
                    release.setInProgressEnvironmentId(env.getId());
                    return release;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }
}

