/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.flutter.commands;

import io.appium.java_client.AppiumBy;
import io.appium.java_client.flutter.commands.FlutterCommandParameter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.openqa.selenium.internal.Require;

public class ScrollParameter
extends FlutterCommandParameter {
    private AppiumBy.FlutterBy scrollTo;
    private AppiumBy.FlutterBy scrollView;
    private ScrollDirection scrollDirection;
    private Integer delta;
    private Integer maxScrolls;
    private Integer settleBetweenScrollsTimeout;
    private Duration dragDuration;

    private ScrollParameter() {
    }

    public ScrollParameter(AppiumBy.FlutterBy scrollTo) {
        this(scrollTo, ScrollDirection.DOWN);
    }

    public ScrollParameter(AppiumBy.FlutterBy scrollTo, ScrollDirection scrollDirection) {
        Require.precondition((scrollTo != null ? 1 : 0) != 0, (String)"Must supply a valid locator for scrollTo", (Object[])new Object[0]);
        this.scrollTo = scrollTo;
        this.scrollDirection = scrollDirection;
    }

    @Override
    public Map<String, Object> toJson() {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("finder", ScrollParameter.parseFlutterLocator(this.scrollTo));
        Optional.ofNullable(this.scrollView).ifPresent(scrollView -> params.put("scrollView", ScrollParameter.parseFlutterLocator(scrollView)));
        Optional.ofNullable(this.delta).ifPresent(delta -> params.put("delta", (Map<String, Object>)delta));
        Optional.ofNullable(this.maxScrolls).ifPresent(maxScrolls -> params.put("maxScrolls", (Map<String, Object>)maxScrolls));
        Optional.ofNullable(this.settleBetweenScrollsTimeout).ifPresent(timeout -> params.put("settleBetweenScrollsTimeout", (Map<String, Object>)((Object)this.settleBetweenScrollsTimeout)));
        Optional.ofNullable(this.scrollDirection).ifPresent(direction -> params.put("scrollDirection", (Map<String, Object>)((Object)direction.getDirection())));
        Optional.ofNullable(this.dragDuration).ifPresent(direction -> params.put("dragDuration", (Map<String, Object>)this.dragDuration.getSeconds()));
        return Collections.unmodifiableMap(params);
    }

    @Generated
    public AppiumBy.FlutterBy getScrollTo() {
        return this.scrollTo;
    }

    @Generated
    public AppiumBy.FlutterBy getScrollView() {
        return this.scrollView;
    }

    @Generated
    public ScrollDirection getScrollDirection() {
        return this.scrollDirection;
    }

    @Generated
    public Integer getDelta() {
        return this.delta;
    }

    @Generated
    public Integer getMaxScrolls() {
        return this.maxScrolls;
    }

    @Generated
    public Integer getSettleBetweenScrollsTimeout() {
        return this.settleBetweenScrollsTimeout;
    }

    @Generated
    public Duration getDragDuration() {
        return this.dragDuration;
    }

    @Generated
    public ScrollParameter setScrollTo(AppiumBy.FlutterBy scrollTo) {
        this.scrollTo = scrollTo;
        return this;
    }

    @Generated
    public ScrollParameter setScrollView(AppiumBy.FlutterBy scrollView) {
        this.scrollView = scrollView;
        return this;
    }

    @Generated
    public ScrollParameter setScrollDirection(ScrollDirection scrollDirection) {
        this.scrollDirection = scrollDirection;
        return this;
    }

    @Generated
    public ScrollParameter setDelta(Integer delta) {
        this.delta = delta;
        return this;
    }

    @Generated
    public ScrollParameter setMaxScrolls(Integer maxScrolls) {
        this.maxScrolls = maxScrolls;
        return this;
    }

    @Generated
    public ScrollParameter setSettleBetweenScrollsTimeout(Integer settleBetweenScrollsTimeout) {
        this.settleBetweenScrollsTimeout = settleBetweenScrollsTimeout;
        return this;
    }

    @Generated
    public ScrollParameter setDragDuration(Duration dragDuration) {
        this.dragDuration = dragDuration;
        return this;
    }

    public static enum ScrollDirection {
        UP("up"),
        RIGHT("right"),
        DOWN("down"),
        LEFT("left");

        private final String direction;

        private ScrollDirection(String direction) {
            this.direction = direction;
        }

        @Generated
        public String getDirection() {
            return this.direction;
        }
    }
}

