/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.imagecomparison;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;

public abstract class ComparisonResult {
    private static final String VISUALIZATION = "visualization";
    protected final Object commandResult;

    public ComparisonResult(Object commandResult) {
        this.commandResult = commandResult;
    }

    protected Map<String, Object> getResultAsMap() {
        return (Map)this.commandResult;
    }

    protected void verifyPropertyPresence(String propertyName) {
        if (!this.getResultAsMap().containsKey(propertyName)) {
            throw new IllegalStateException(String.format("There is no '%s' attribute in the resulting command output %s. Did you set the options properly?", propertyName, this.commandResult));
        }
    }

    public byte[] getVisualization() {
        this.verifyPropertyPresence(VISUALIZATION);
        return ((String)this.getResultAsMap().get(VISUALIZATION)).getBytes(StandardCharsets.UTF_8);
    }

    public void storeVisualization(File destination) throws IOException {
        byte[] data = Base64.getDecoder().decode(this.getVisualization());
        try (FileOutputStream stream = new FileOutputStream(destination);){
            ((OutputStream)stream).write(data);
        }
    }

    private static int toSeleniumCoordinate(Object openCVCoordinate) {
        if (openCVCoordinate instanceof Long) {
            return ((Long)openCVCoordinate).intValue();
        }
        if (openCVCoordinate instanceof Double) {
            return ((Double)openCVCoordinate).intValue();
        }
        return (Integer)openCVCoordinate;
    }

    public static Rectangle mapToRect(Map<String, Object> map) {
        return new Rectangle(ComparisonResult.toSeleniumCoordinate(map.get("x")), ComparisonResult.toSeleniumCoordinate(map.get("y")), ComparisonResult.toSeleniumCoordinate(map.get("height")), ComparisonResult.toSeleniumCoordinate(map.get("width")));
    }

    public static Point mapToPoint(Map<String, Object> map) {
        return new Point(ComparisonResult.toSeleniumCoordinate(map.get("x")), ComparisonResult.toSeleniumCoordinate(map.get("y")));
    }
}

