/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.windows;

import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WindowsStartScreenRecordingOptions
extends BaseStartScreenRecordingOptions<WindowsStartScreenRecordingOptions> {
    private Integer fps;
    private String videoFilter;
    private String preset;
    private Boolean captureCursor;
    private Boolean captureClicks;
    private String audioInput;

    public static WindowsStartScreenRecordingOptions startScreenRecordingOptions() {
        return new WindowsStartScreenRecordingOptions();
    }

    public WindowsStartScreenRecordingOptions withFps(int fps) {
        this.fps = fps;
        return this;
    }

    public WindowsStartScreenRecordingOptions enableCursorCapture() {
        this.captureCursor = true;
        return this;
    }

    public WindowsStartScreenRecordingOptions enableClicksCapture() {
        this.captureClicks = true;
        return this;
    }

    public WindowsStartScreenRecordingOptions withAudioInput(String audioInput) {
        this.audioInput = audioInput;
        return this;
    }

    public WindowsStartScreenRecordingOptions withVideoFilter(String videoFilter) {
        this.videoFilter = videoFilter;
        return this;
    }

    public WindowsStartScreenRecordingOptions withPreset(String preset) {
        this.preset = preset;
        return this;
    }

    @Override
    public WindowsStartScreenRecordingOptions withTimeLimit(Duration timeLimit) {
        return (WindowsStartScreenRecordingOptions)super.withTimeLimit(timeLimit);
    }

    @Override
    public Map<String, Object> build() {
        HashMap<String, Object> map = new HashMap<String, Object>(super.build());
        Optional.ofNullable(this.fps).map(x -> map.put("fps", x));
        Optional.ofNullable(this.preset).map(x -> map.put("preset", x));
        Optional.ofNullable(this.videoFilter).map(x -> map.put("videoFilter", x));
        Optional.ofNullable(this.captureClicks).map(x -> map.put("captureClicks", x));
        Optional.ofNullable(this.captureCursor).map(x -> map.put("captureCursor", x));
        Optional.ofNullable(this.audioInput).map(x -> map.put("audioInput", x));
        return Collections.unmodifiableMap(map);
    }
}

