/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testops.service;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

class ZonedDateTimeAdapter
implements JsonSerializer<ZonedDateTime>,
JsonDeserializer<ZonedDateTime> {
    private DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;

    public ZonedDateTimeAdapter() {
    }

    public ZonedDateTimeAdapter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return ZonedDateTime.parse(json.getAsString(), this.formatter);
    }

    public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }
}

