/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.NewFilteringTestSuiteDialog;
import com.kms.katalon.composer.testsuite.handlers.NewTestSuiteHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewFilteringTestSuiteHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private FolderTreeEntity testSuiteTreeRoot;
    private String newDefaultName = "New Dynamic Test Suite";

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            TestSuiteController tsController;
            String suggestedName;
            if (!this.featureController.canUse(ProductFeature.DYNAMIC_TEST_SUITE)) {
                this.productFeatureDialog.showNotAvailableFeature(ProductFeature.DYNAMIC_TEST_SUITE);
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity parentTreeEntity = NewTestSuiteHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.testSuiteTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.testSuiteTreeRoot;
            }
            if (parentTreeEntity == null) {
                return;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            NewFilteringTestSuiteDialog dialog = new NewFilteringTestSuiteDialog(parentShell, parentFolderEntity, suggestedName = (tsController = TestSuiteController.getInstance()).getAvailableTestSuiteName(parentFolderEntity, this.newDefaultName));
            if (dialog.open() != 0) {
                return;
            }
            TestSuiteEntity testSuite = tsController.saveNewTestSuite((TestSuiteEntity)dialog.getEntity());
            if (testSuite == null) {
                MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
                return;
            }
            Trackings.trackCreatingObject((String)"filteringTestSuite", (Object[])new Object[0]);
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestSuiteTreeEntity(testSuite, parentTreeEntity));
            this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuite);
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
        }
    }
}

