/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.dal.exception.NullAttributeException;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestSuiteHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object instanceof TestSuiteTreeEntity) {
                    TestSuiteTreeEntity testSuiteTreeEntity = (TestSuiteTreeEntity)object;
                    RenameTestSuiteHandler.this.execute(testSuiteTreeEntity);
                }
            }
        });
    }

    private void execute(TestSuiteTreeEntity testSuiteTreeEntity) {
        block6: {
            try {
                TestSuiteEntity testSuite = testSuiteTreeEntity.getObject();
                if (Objects.isNull(testSuite)) {
                    throw new NullAttributeException("TestSuiteEntity is null");
                }
                List existingNames = FolderController.getInstance().getChildrenNames(testSuite.getParentFolder());
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)testSuiteTreeEntity, existingNames);
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                if (wizardDialog.open() != 0) break block6;
                String oldName = testSuite.getName();
                String pk = testSuite.getId();
                String oldIdForDisplay = testSuite.getIdForDisplay();
                String newNameValue = renameWizard.getNewNameValue();
                try {
                    if (!StringUtils.equals((CharSequence)newNameValue, (CharSequence)oldName)) {
                        TestSuiteEntity newTestSuite = TestSuiteController.getInstance().renameTestSuite(newNameValue, testSuite);
                        String newIdForDisplay = newTestSuite.getIdForDisplay();
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                    }
                }
                catch (Exception ex) {
                    testSuite.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    String errorMessage = "";
                    errorMessage = ex instanceof FilePathTooLongException ? ex.getMessage() : ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_SUITE;
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)errorMessage);
                    return;
                }
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testSuiteTreeEntity.getParent());
                this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{pk, testSuite});
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testSuiteTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

