/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.AddMailRecipientDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.parts.FilteringTestCaseView;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.events.TestCaseUpdatedEvent;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.events.TestDataUpdatedEvent;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.platform.DynamicQueryingTestSuiteExtensionProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.EventHandler;

public class FilteringTestSuitePart
implements EventHandler {
    private static final int MINIMUM_COMPOSITE_SIZE = 300;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private DynamicQueryingTestSuiteExtensionProvider extensionProvider;
    private Composite compositeExecution;
    private Composite compositeMain;
    private boolean isExecutionCompositeExpanded;
    private Text txtRerun;
    private Text txtUserDefinePageLoadTimeout;
    private MPart mpart;
    private Composite compositeExecutionDetails;
    private org.eclipse.swt.widgets.List listMailRcp;
    private ListViewer listMailRcpViewer;
    private Button btnAddMailRcp;
    private Button btnDeleteMailRcp;
    private Button btnClearMailRcp;
    private Button radioUseDefaultPageLoadTimeout;
    private Button radioUserDefinePageLoadTimeout;
    private Composite compositeLastRunAndReRun;
    private ImageButton btnExpandExecutionComposite;
    private Button rerunAllTestCases;
    private Button rerunFailedTestCasesOnly;
    private ParentTestSuiteCompositePart parentTestSuiteCompositePart;
    private Label lblExecutionInformation;
    private FilteringTestCaseView childrenView;
    private List<Thread> uiThreads;
    private Composite parent;
    private boolean isLoading;
    private Listener layoutExecutionCompositeListener = new Listener(){

        public void handleEvent(Event event) {
            FilteringTestSuitePart.this.isExecutionCompositeExpanded = !FilteringTestSuitePart.this.isExecutionCompositeExpanded;
            FilteringTestSuitePart.this.layoutExecutionInfo();
        }
    };

    @PostConstruct
    public void createControls(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.parent = parent;
        this.mpart = mpart;
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof ParentTestSuiteCompositePart) {
            this.parentTestSuiteCompositePart = (ParentTestSuiteCompositePart)compositePart.getObject();
        }
        this.childrenView = new FilteringTestCaseView(this.parentTestSuiteCompositePart, this);
        this.uiThreads = new LinkedList<Thread>();
        this.isLoading = false;
        this.initExpandedState();
        this.registerEventBrokerListerners();
        this.createComponents(parent);
        this.registerControlListeners();
        this.layoutExecutionInfo();
        this.childrenView.layout();
    }

    public MPart getMPart() {
        return this.mpart;
    }

    private void initExpandedState() {
        this.isExecutionCompositeExpanded = false;
        this.childrenView.initExpandedState();
    }

    @Focus
    public void setFocus() {
        this.compositeMain.setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.setDirty(false);
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    private void registerEventBrokerListerners() {
        this.eventBroker.subscribe("TESTSUITE/UPDATE_DIRTY", (EventHandler)this);
        this.eventBroker.subscribe("TESTSUITE/UPDATE_IS_RUN_COLUMN_HEADER", (EventHandler)this);
        this.eventBroker.subscribe("TESTCASE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTSUITE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTDATA/UPDATE", (EventHandler)this);
        this.eventBroker.subscribe("ADD_TESTCASE_TESTCASE", (EventHandler)this);
        this.eventBroker.subscribe("TESTCASE/DELETE", (EventHandler)this);
        this.eventBroker.subscribe("FOLDER/DELETE_TESTCASE_FOLDER", (EventHandler)this);
    }

    private void layoutExecutionInfo() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                FilteringTestSuitePart.this.compositeExecutionDetails.setVisible(FilteringTestSuitePart.this.isExecutionCompositeExpanded);
                if (!FilteringTestSuitePart.this.isExecutionCompositeExpanded) {
                    ((GridData)FilteringTestSuitePart.this.compositeExecutionDetails.getLayoutData()).exclude = true;
                    FilteringTestSuitePart.this.compositeExecution.setSize(FilteringTestSuitePart.this.compositeExecution.getSize().x, FilteringTestSuitePart.this.compositeExecution.getSize().y - FilteringTestSuitePart.this.childrenView.getComponent().getSize().y);
                } else {
                    ((GridData)FilteringTestSuitePart.this.compositeExecutionDetails.getLayoutData()).exclude = false;
                }
                FilteringTestSuitePart.this.compositeExecution.layout(true, true);
                FilteringTestSuitePart.this.compositeExecution.getParent().layout();
                FilteringTestSuitePart.this.redrawBtnExpandExecutionInfo();
            }
        });
    }

    private void registerControlListeners() {
        this.btnAddMailRcp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] emails;
                Shell shell = Display.getDefault().getActiveShell();
                AddMailRecipientDialog addMailDialog = new AddMailRecipientDialog(shell, FilteringTestSuitePart.this.listMailRcpViewer.getList().getItems());
                addMailDialog.open();
                if (addMailDialog.getReturnCode() == 0 && (emails = addMailDialog.getEmails()).length > 0) {
                    FilteringTestSuitePart.this.listMailRcpViewer.add((Object[])addMailDialog.getEmails());
                    FilteringTestSuitePart.this.setDirty(true);
                }
            }
        });
        this.btnClearMailRcp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteringTestSuitePart.this.listMailRcpViewer.getList().getItemCount() > 0) {
                    FilteringTestSuitePart.this.listMailRcpViewer.setInput((Object)new String[0]);
                    FilteringTestSuitePart.this.setDirty(true);
                }
            }
        });
        this.btnDeleteMailRcp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] emails = ((IStructuredSelection)FilteringTestSuitePart.this.listMailRcpViewer.getSelection()).toArray();
                if (emails.length > 0) {
                    FilteringTestSuitePart.this.listMailRcpViewer.remove(emails);
                    FilteringTestSuitePart.this.setDirty(true);
                }
            }
        });
        this.lblExecutionInformation.addListener(3, this.layoutExecutionCompositeListener);
        this.btnExpandExecutionComposite.addListener(3, this.layoutExecutionCompositeListener);
        this.radioUseDefaultPageLoadTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringTestSuitePart.this.txtUserDefinePageLoadTimeout.setEnabled(false);
                FilteringTestSuitePart.this.getTestSuite().setPageLoadTimeoutDefault(true);
                FilteringTestSuitePart.this.setDirty(true);
            }
        });
        this.radioUserDefinePageLoadTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringTestSuitePart.this.txtUserDefinePageLoadTimeout.setEnabled(true);
                FilteringTestSuitePart.this.getTestSuite().setPageLoadTimeoutDefault(false);
                FilteringTestSuitePart.this.setDirty(true);
            }
        });
        VerifyListener verifyNumberListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                FilteringTestSuitePart.this.setDirty(true);
            }
        };
        this.txtUserDefinePageLoadTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                try {
                    int timeout = Integer.parseInt(text);
                    FilteringTestSuitePart.this.getTestSuite().setPageLoadTimeout(Short.valueOf((short)timeout));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.txtUserDefinePageLoadTimeout.addVerifyListener(verifyNumberListener);
        this.txtRerun.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                try {
                    int rerun = Integer.parseInt(text);
                    if (rerun > 100) {
                        rerun = 100;
                        ((Text)e.getSource()).setText(String.valueOf(rerun));
                    }
                    FilteringTestSuitePart.this.getTestSuite().setNumberOfRerun(rerun);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.txtRerun.addVerifyListener(verifyNumberListener);
        this.rerunFailedTestCasesOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringTestSuitePart.this.getTestSuite().setRerunFailedTestCasesOnly(FilteringTestSuitePart.this.rerunFailedTestCasesOnly.getSelection());
                FilteringTestSuitePart.this.setDirty(true);
            }
        });
        this.childrenView.registerControlModifyListeners();
    }

    public void loadTestSuite(TestSuiteEntity testSuite) {
        try {
            this.loadTestSuiteInfo(testSuite);
            this.childrenView.loadInput();
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to open Filtering Test Suite", (String)e.getMessage());
        }
    }

    private void loadTestSuiteInfo(TestSuiteEntity testSuite) throws Exception {
        this.txtRerun.setText(String.valueOf(testSuite.getNumberOfRerun()));
        boolean isRerunFailedTestCasesOnly = testSuite.isRerunFailedTestCasesOnly();
        this.rerunFailedTestCasesOnly.setSelection(isRerunFailedTestCasesOnly);
        this.rerunAllTestCases.setSelection(!isRerunFailedTestCasesOnly);
        this.listMailRcpViewer.setInput((Object)TestSuiteController.getInstance().mailRcpStringToArray(testSuite.getMailRecipient()));
        short pageLoadTimeOut = testSuite.getPageLoadTimeout();
        if (testSuite.isPageLoadTimeoutDefault()) {
            this.radioUseDefaultPageLoadTimeout.setSelection(true);
            this.radioUserDefinePageLoadTimeout.setSelection(false);
            this.txtUserDefinePageLoadTimeout.setEnabled(false);
        } else {
            this.radioUseDefaultPageLoadTimeout.setSelection(false);
            this.radioUserDefinePageLoadTimeout.setSelection(true);
            this.txtUserDefinePageLoadTimeout.setEnabled(true);
            this.txtUserDefinePageLoadTimeout.setText(Integer.toString(pageLoadTimeOut));
        }
    }

    private void createComponents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.compositeMain = new Composite(parent, 0);
        GridLayout glCompositeMain = new GridLayout(1, false);
        glCompositeMain.marginWidth = 0;
        glCompositeMain.marginHeight = 0;
        this.compositeMain.setLayout((Layout)glCompositeMain);
        this.compositeMain.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createExecutionInformationComposite();
        this.childrenView.createComponent(this.compositeMain);
    }

    private void redrawBtnExpandExecutionInfo() {
        this.btnExpandExecutionComposite.getParent().setRedraw(false);
        if (this.isExecutionCompositeExpanded) {
            this.btnExpandExecutionComposite.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandExecutionComposite.setImage(ImageConstants.IMG_16_ARROW);
        }
        this.btnExpandExecutionComposite.getParent().setRedraw(true);
    }

    private void createExecutionInformationComposite() {
        this.compositeExecution = new Composite(this.compositeMain, 0);
        this.compositeExecution.setBackground(ColorUtil.getCompositeBackgroundColor());
        GridLayout glCompositeExecution = new GridLayout(1, true);
        glCompositeExecution.verticalSpacing = 0;
        glCompositeExecution.horizontalSpacing = 0;
        glCompositeExecution.marginHeight = 0;
        glCompositeExecution.marginWidth = 0;
        this.compositeExecution.setLayout((Layout)glCompositeExecution);
        this.compositeExecution.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeExecutionCompositeHeader = new Composite(this.compositeExecution, 0);
        compositeExecutionCompositeHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeExecutionCompositeHeader = new GridLayout(2, false);
        glCompositeExecutionCompositeHeader.marginHeight = 0;
        glCompositeExecutionCompositeHeader.marginWidth = 0;
        compositeExecutionCompositeHeader.setLayout((Layout)glCompositeExecutionCompositeHeader);
        compositeExecutionCompositeHeader.setCursor(compositeExecutionCompositeHeader.getDisplay().getSystemCursor(21));
        compositeExecutionCompositeHeader.setCursor(compositeExecutionCompositeHeader.getDisplay().getSystemCursor(21));
        this.btnExpandExecutionComposite = new ImageButton(compositeExecutionCompositeHeader, 0);
        this.redrawBtnExpandExecutionInfo();
        this.lblExecutionInformation = new Label(compositeExecutionCompositeHeader, 0);
        this.lblExecutionInformation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblExecutionInformation.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.lblExecutionInformation.setText("Execution Information");
        this.compositeExecutionDetails = new Composite(this.compositeExecution, 0);
        this.compositeExecutionDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glCompositeExecutionDetail = new GridLayout(2, false);
        glCompositeExecutionDetail.marginLeft = 45;
        glCompositeExecutionDetail.horizontalSpacing = 40;
        this.compositeExecutionDetails.setLayout((Layout)glCompositeExecutionDetail);
        Composite compositePageLoadTimeout = new Composite(this.compositeExecutionDetails, 0);
        GridData gdCompositePageLoadTimeout = new GridData(4, 4, false, true, 1, 1);
        gdCompositePageLoadTimeout.minimumWidth = 300;
        compositePageLoadTimeout.setLayoutData((Object)gdCompositePageLoadTimeout);
        GridLayout glCompositePageLoadTimeout = new GridLayout(1, false);
        glCompositePageLoadTimeout.marginWidth = 0;
        glCompositePageLoadTimeout.marginHeight = 0;
        glCompositePageLoadTimeout.horizontalSpacing = 10;
        compositePageLoadTimeout.setLayout((Layout)glCompositePageLoadTimeout);
        Group grpPageLoadTimeout = new Group(compositePageLoadTimeout, 0);
        grpPageLoadTimeout.setText(ComposerTestsuiteMessageConstants.PA_LBL_PAGE_LOAD_TIMEOUT);
        grpPageLoadTimeout.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_grpPageLoadTimeout = new GridLayout(2, false);
        gl_grpPageLoadTimeout.marginLeft = 20;
        gl_grpPageLoadTimeout.marginWidth = 0;
        grpPageLoadTimeout.setLayout((Layout)gl_grpPageLoadTimeout);
        this.radioUseDefaultPageLoadTimeout = new Button((Composite)grpPageLoadTimeout, 16);
        this.radioUseDefaultPageLoadTimeout.setText(ComposerTestsuiteMessageConstants.PA_LBL_USE_DEFAULT);
        new Label((Composite)grpPageLoadTimeout, 0);
        this.radioUserDefinePageLoadTimeout = new Button((Composite)grpPageLoadTimeout, 16);
        GridData gd_radioUserDefinePageLoadTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.radioUserDefinePageLoadTimeout.setLayoutData((Object)gd_radioUserDefinePageLoadTimeout);
        this.radioUserDefinePageLoadTimeout.setText(ComposerTestsuiteMessageConstants.PA_LBL_USER_DEFINE);
        this.txtUserDefinePageLoadTimeout = new Text((Composite)grpPageLoadTimeout, 2048);
        GridData gdTxtUserDefinePageLoadTimeout = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtUserDefinePageLoadTimeout.heightHint = 20;
        this.txtUserDefinePageLoadTimeout.setLayoutData((Object)gdTxtUserDefinePageLoadTimeout);
        this.txtUserDefinePageLoadTimeout.setTextLimit(4);
        this.compositeLastRunAndReRun = (Composite)ComponentBuilder.gridContainer((Composite)compositePageLoadTimeout, (int)3).fill().gridHorizontalSpacing(10).gridVerticalSpacing(10).build();
        ComponentBuilder.radio((Composite)this.compositeLastRunAndReRun).text(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_AFTER_EXECUTE_ALL).title(ComposerTestsuiteMessageConstants.PA_LBL_TOOLTIP_RETRY).fillHorizontal().check().build();
        this.txtRerun = (Text)ComponentBuilder.text((Composite)this.compositeLastRunAndReRun, (int)2048).title(ComposerTestsuiteMessageConstants.PA_LBL_TOOLTIP_RETRY).limit(3).fillHorizontal().autoWidth(20).build();
        ComponentBuilder.helpButton((Composite)this.compositeLastRunAndReRun, (String)DocumentationMessageConstants.TEST_SUITE_OPTIONS).build();
        Composite retryOptionsGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.compositeLastRunAndReRun).colSpan(3).groupIndent().fillHorizontal().build();
        this.rerunAllTestCases = (Button)ComponentBuilder.radio((Composite)retryOptionsGroup).text(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_ALL_EXECUTIONS).fillHorizontal().build();
        this.rerunFailedTestCasesOnly = (Button)ComponentBuilder.radio((Composite)retryOptionsGroup).text(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_FAILED_EXECUTIONS).fillHorizontal().build();
        Composite compositeMailRecipients = new Composite(this.compositeExecutionDetails, 0);
        GridData gdCompositeMailRecipients = new GridData(4, 4, true, true, 1, 1);
        compositeMailRecipients.setLayoutData((Object)gdCompositeMailRecipients);
        GridLayout glCompositeMailRecipients = new GridLayout(3, false);
        compositeMailRecipients.setLayout((Layout)glCompositeMailRecipients);
        Label lblMailRecipients = new Label(compositeMailRecipients, 0);
        GridData gdLblMailRecipients = new GridData(16384, 128, false, false, 1, 1);
        gdLblMailRecipients.verticalIndent = 5;
        lblMailRecipients.setLayoutData((Object)gdLblMailRecipients);
        lblMailRecipients.setText(ComposerTestsuiteMessageConstants.PA_LBL_MAIL_RECIPIENTS);
        this.listMailRcpViewer = new ListViewer(compositeMailRecipients, 2560);
        this.listMailRcp = this.listMailRcpViewer.getList();
        this.listMailRcp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listMailRcpViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite compositeMailRcpButtons = new Composite(compositeMailRecipients, 0);
        compositeMailRcpButtons.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        GridLayout glCompositeMailRcpButtons = new GridLayout(1, false);
        glCompositeMailRcpButtons.marginWidth = 0;
        glCompositeMailRcpButtons.marginHeight = 0;
        compositeMailRcpButtons.setLayout((Layout)glCompositeMailRcpButtons);
        this.btnAddMailRcp = new Button(compositeMailRcpButtons, 0x800000);
        this.btnAddMailRcp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnAddMailRcp.setText(StringConstants.PA_BTN_ADD);
        this.btnDeleteMailRcp = new Button(compositeMailRcpButtons, 0x800000);
        this.btnDeleteMailRcp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDeleteMailRcp.setText(StringConstants.PA_BTN_DEL);
        this.btnClearMailRcp = new Button(compositeMailRcpButtons, 0x800000);
        this.btnClearMailRcp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnClearMailRcp.setText(StringConstants.PA_BTN_CLEAR);
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (event.getTopic().equals("TESTCASE/UPDATED")) {
            Object object = event.getProperty("org.eclipse.e4.data");
            if (object == null) {
                return;
            }
            if (object instanceof TestCaseUpdatedEvent) {
                try {
                    TestCaseUpdatedEvent eventData = (TestCaseUpdatedEvent)object;
                    String oldPk = eventData.getOriginalPk();
                    TestCaseEntity testCase = (TestCaseEntity)eventData.getTestCaseEntity();
                    String newPK = testCase.getId();
                    if (!oldPk.equals(newPK)) {
                        this.childrenView.resetTestCasePreviewTable();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        } else if (event.getTopic().equals("TESTDATA/UPDATE")) {
            try {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object instanceof TestDataUpdatedEvent) {
                    TestDataUpdatedEvent eventData = (TestDataUpdatedEvent)object;
                    String oldTestDataPk = eventData.getOriginalPk();
                    DataFileEntity newTestData = eventData.getDataFileEntity();
                    String projectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                    TestDataController.getInstance().getTestDataDisplayIdByPk(oldTestDataPk, projectLocation);
                    TestDataController.getInstance().getTestDataDisplayIdByPk(newTestData.getId(), projectLocation);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (event.getTopic().equals("TESTCASE/DELETE")) {
            List<TestCaseEntity> tcs = this.childrenView.getFilteredTestCases();
            Object id = event.getProperty("org.eclipse.e4.data");
            if (tcs != null && id != null) {
                boolean isExist;
                boolean bl = isExist = tcs.stream().filter(tc -> tc.getId().equals((String)id)).findAny().orElse(null) != null;
                if (isExist) {
                    this.childrenView.resetTestCasePreviewTable();
                }
            }
        } else if (event.getTopic().equals("FOLDER/DELETE_TESTCASE_FOLDER")) {
            this.childrenView.resetTestCasePreviewTable();
        }
    }

    public void dispose() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public void setDirty(boolean dirty) {
        if (!this.isTestSuiteLoading()) {
            this.mpart.setDirty(dirty);
            this.parentTestSuiteCompositePart.setDirty(dirty);
        }
    }

    TestSuiteEntity getTestSuite() {
        return this.parentTestSuiteCompositePart.getTestSuiteClone();
    }

    public boolean prepareForSaving() {
        this.childrenView.beforeSaving();
        this.getTestSuite().setMailRecipient(TestSuiteController.getInstance().arrayMailRcpToString(this.listMailRcpViewer.getList().getItems()));
        return true;
    }

    void afterSaving() {
        this.childrenView.afterSaving();
    }

    void interuptUIThreads() {
        for (Thread thread : this.uiThreads) {
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        this.uiThreads.clear();
        this.isLoading = false;
    }

    private boolean isTestSuiteLoading() {
        for (Thread thread : this.uiThreads) {
            if (!thread.isAlive()) continue;
            return true;
        }
        return this.isLoading;
    }

    public void openAddTestCaseDialog() {
    }

    public void openAddedTestCase(TestCaseEntity testCaseEntity) {
        this.eventBroker.post("TESTCASE/OPEN", (Object)testCaseEntity);
    }

    public void openAddedTestData(DataFileEntity dataFileEntity) {
        this.eventBroker.post("TESTDATA/OPEN", (Object)dataFileEntity);
    }

    public DynamicQueryingTestSuiteExtensionProvider getExtensionProvider() {
        return this.extensionProvider;
    }
}

