/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.helper.UIEventController;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class TestSuiteAnalyticsPart {
    private Composite mainComposite;
    private TestSuiteEntity testSuite;
    private Browser browser;
    private EventEmitter.EventSubscriber settingsChangeSubscriber;

    public void setTestSuite(TestSuiteEntity testSuite) {
        this.testSuite = testSuite;
        this.browser.setUrl(this.getUrlForTestSuiteAnalytics());
    }

    @PostConstruct
    public void init(Composite parent) {
        this.createControls(parent);
        this.settingsChangeSubscriber = UIEventController.getInstance().onSettingsChange(page -> {
            if (page != UIEventController.SettingPage.TESTOPS) {
                return;
            }
            try {
                this.browser.refresh();
            }
            catch (Exception error) {
                LoggerSingleton.logError((Throwable)error);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        EventEmitter.safeUnsubscribe((EventEmitter.EventSubscriber)this.settingsChangeSubscriber);
    }

    private void createControls(Composite parent) {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        this.browser = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).defaultBrowserConfig().fill().build();
    }

    private String getUrlForTestSuiteAnalytics() {
        String testSuiteName = "";
        String testSuitePathWithoutName = "";
        if (this.testSuite != null) {
            String testSuitePath = this.testSuite.getIdForDisplay();
            testSuitePathWithoutName = testSuitePath.substring(0, testSuitePath.lastIndexOf("/"));
            testSuiteName = this.testSuite.getName();
        }
        return WebViewController.getInstance().getPage("TestSuiteAnalytics.html?testSuitePath=" + testSuitePathWithoutName + "&testSuiteName=" + testSuiteName);
    }
}

