/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testcase.actions.KatalonFormatAction;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;

public class TestSuiteScriptPart {
    private CompatibilityEditor editorPart;
    private GroovyEditor groovyEditor;
    private ShowProblemAction showProblemAction;
    private SavableCompositePart parentPart;

    public TestSuiteScriptPart(ParentTestSuiteCompositePart parentPart, CompatibilityEditor editorPart) {
        this.parentPart = parentPart;
        this.editorPart = editorPart;
        this.groovyEditor = (GroovyEditor)editorPart.getEditor();
    }

    public MPart getMPart() {
        return this.editorPart.getModel();
    }

    public void initEditorAction() {
        this.addFormatAction();
        this.addSyntaxCheckingAction();
        this.addImportAction();
    }

    private void addImportAction() {
        GroovyEditorUtil.addImportActions((GroovyEditor)this.groovyEditor);
    }

    private void addSyntaxCheckingAction() {
        this.showProblemAction = new ShowProblemAction(this.groovyEditor);
        this.groovyEditor.getViewer().getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                TestSuiteScriptPart.this.showProblemAction.startAction();
                TestSuiteScriptPart.this.getMPart().setDirty(true);
                TestSuiteScriptPart.this.parentPart.setDirty(true);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void addFormatAction() {
        if (this.groovyEditor.getAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT) instanceof KatalonFormatAction) {
            return;
        }
        KatalonFormatAction formatAction = new KatalonFormatAction((IWorkbenchSite)this.groovyEditor.getSite(), FormatKind.FORMAT);
        formatAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.groovyEditor.setAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT, (IAction)formatAction);
    }

    public void save() {
        this.groovyEditor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    private class ShowProblemAction {
        private static final long MAX_WAITING_TIME = 200L;
        private static final long TICK = 50L;
        private long countdown;
        private Thread showProblemThread;
        private GroovyEditor editor;

        private Thread createShowProblemThread() {
            return new Thread(() -> {
                while (this.countdown < 200L) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.countdown += 50L;
                }
                UISynchronizeService.syncExec(() -> {
                    try {
                        GroovyEditorUtil.showProblems((GroovyEditor)this.editor);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                });
            });
        }

        public ShowProblemAction(GroovyEditor editor) {
            this.editor = editor;
        }

        public void startAction() {
            this.countdown = 0L;
            if (this.showProblemThread == null || !this.showProblemThread.isAlive()) {
                this.showProblemThread = this.createShowProblemThread();
                this.showProblemThread.start();
            }
        }

        public void endAction() {
            if (this.showProblemThread != null && this.showProblemThread.isAlive()) {
                try {
                    this.showProblemThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

