/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.support;

import com.kms.katalon.composer.components.impl.editors.TestDataCellEditor;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class TestDataIDColumnEditingSupport
extends EditingSupport {
    private TestSuitePartDataBindingView mpart;

    public TestDataIDColumnEditingSupport(ColumnViewer viewer, TestSuitePartDataBindingView view) {
        super(viewer);
        this.mpart = view;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element != null && element instanceof TestCaseTestDataLink) {
            TestCaseTestDataLink link = (TestCaseTestDataLink)element;
            return new TestDataCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), link.getTestDataId(), link.getTestDataId());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        if (!this.mpart.getSelectedTestCaseLink().isUsingDataBindingAtTestSuiteLevel()) {
            return false;
        }
        return element != null && element instanceof TestCaseTestDataLink;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof TestCaseTestDataLink) {
            TestCaseTestDataLink link = (TestCaseTestDataLink)element;
            return link.getTestDataId();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        try {
            if (element != null && element instanceof TestCaseTestDataLink && value instanceof TestDataTreeEntity) {
                TestCaseTestDataLink link = (TestCaseTestDataLink)element;
                TestDataTreeEntity treeEntity = (TestDataTreeEntity)value;
                DataFileEntity testDataEntity = treeEntity.getObject();
                String testDataId = testDataEntity.getIdForDisplay();
                if (testDataId != null && !testDataId.equals(link.getTestDataId())) {
                    link.setTestDataId(testDataId);
                    this.getViewer().update(element, null);
                    this.refreshVariableLink(link.getId());
                    this.mpart.setDirty(true);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void refreshVariableLink(String testDataLinkId) {
        if (this.mpart.getSelectedTestCaseLink() == null) {
            return;
        }
        for (VariableLink variableLink : this.mpart.getSelectedTestCaseLink().getVariableLinks()) {
            if (variableLink.getType() != VariableLink.VariableType.DATA_COLUMN && variableLink.getType() != VariableLink.VariableType.DATA_COLUMN_INDEX || !testDataLinkId.equals(variableLink.getTestDataLinkId())) continue;
            variableLink.setValue("");
            this.mpart.refreshVariableLink(variableLink);
        }
    }
}

