/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.driver;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.windows.driver.WindowsDesiredCapsBuilder;
import com.kms.katalon.core.windows.driver.WindowsDriverFactory;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import io.appium.java_client.windows.WindowsDriver;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;

public class WindowsSession {
    private WindowsDriver applicationDriver;
    private WindowsDriver desktopDriver;
    private TargetAppType targetAppType = TargetAppType.SPECIFIC_APP;
    private final URL remoteAddressURL;
    private final String appFile;
    private final DesiredCapabilities initCapabilities;
    private final ProxyInformation proxyInfo;
    private final String appTitle;
    private final StringMatchingStrategy appTitleMatchingStrategy;

    public WindowsSession(URL remoteAddressURL, String appFile, DesiredCapabilities initCapabilities, ProxyInformation proxyInfo, String appTitle, StringMatchingStrategy appTitleMatchingStrategy) {
        this.remoteAddressURL = remoteAddressURL;
        this.appFile = appFile;
        this.initCapabilities = initCapabilities;
        this.proxyInfo = proxyInfo;
        this.appTitle = appTitle;
        this.appTitleMatchingStrategy = appTitleMatchingStrategy;
    }

    public WindowsDriver getOrCreateDesktopDriver() throws IOException, URISyntaxException {
        if (this.desktopDriver == null) {
            this.desktopDriver = new WindowsDriver((HttpCommandExecutor)WindowsDriverFactory.getAppiumExecutorForRemoteDriver(this.remoteAddressURL, this.proxyInfo, (MutableCapabilities)this.initCapabilities), (Capabilities)new WindowsDesiredCapsBuilder().withRootApp().build());
        }
        return this.desktopDriver;
    }

    public WindowsDriver getApplicationDriver() {
        return this.applicationDriver;
    }

    public void setApplicationDriver(WindowsDriver applicationDriver) {
        this.applicationDriver = applicationDriver;
    }

    public TargetAppType getTargetAppType() {
        return this.targetAppType;
    }

    public void setTargetAppType(TargetAppType targetAppType) {
        this.targetAppType = targetAppType;
    }

    public WindowsDriver getRunningDriver() {
        return TargetAppType.SPECIFIC_APP.equals((Object)this.targetAppType) ? this.applicationDriver : this.desktopDriver;
    }

    public URL getRemoteAddressURL() {
        return this.remoteAddressURL;
    }

    public String getAppFile() {
        return this.appFile;
    }

    public DesiredCapabilities getInitCapabilities() {
        return this.initCapabilities;
    }

    public ProxyInformation getProxyInfo() {
        return this.proxyInfo;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public StringMatchingStrategy getAppTitleMatchingStrategy() {
        return this.appTitleMatchingStrategy;
    }

    public static enum TargetAppType {
        SPECIFIC_APP,
        ROOT_APP;

    }
}

