/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.keyword.helper;

import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.win32.StdCallLibrary;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class WindowFinder {
    static final User32 user32 = User32.INSTANCE;

    public Window findWindowWithTitle(String title, StringMatchingStrategy strategy, int timeout) throws InterruptedException {
        if (strategy == null) {
            return this.findWindowWithTitleContains(title, timeout);
        }
        switch (strategy) {
            case EXACT: {
                return this.findWindowWithExactTitle(title, timeout);
            }
            case CONTAINS: {
                return this.findWindowWithTitleContains(title, timeout);
            }
            case REGEXP: {
                return this.findWindowWithTitlePattern(title, timeout);
            }
        }
        return this.findWindowWithTitleContains(title, timeout);
    }

    public Window findWindowWithExactTitle(String title, int timeout) throws InterruptedException {
        return this.findWindow(title, false, timeout);
    }

    public Window findWindowWithTitleContains(String aPartOfTitle, int timeout) throws InterruptedException {
        return this.findWindowWithTitlePattern(Strings.getContainsPattern((String)aPartOfTitle), timeout);
    }

    public Window findWindowWithTitlePattern(String pattern, int timeout) throws InterruptedException {
        return this.findWindow(pattern, true, timeout);
    }

    public Window findWindow(String title, boolean useRegExp, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        final Window[] windows = new Window[1];
        while (true) {
            if (useRegExp) {
                final Pattern pattern = Pattern.compile(title);
                user32.EnumWindows(new User32.WNDENUMPROC(){

                    @Override
                    public boolean callback(Pointer handle, Pointer arg) {
                        if (!user32.IsWindowVisible(handle).booleanValue()) {
                            return true;
                        }
                        char[] windowText = new char[1024];
                        user32.GetWindowTextW(handle, windowText, 1024);
                        String wText = Native.toString((char[])windowText).trim();
                        if (StringUtils.isEmpty((CharSequence)wText)) {
                            return true;
                        }
                        if (pattern.matcher(wText).matches()) {
                            Window foundWindow = new Window();
                            foundWindow.title = wText;
                            foundWindow.handle = Long.toHexString((Long)ObjectUtil.getField((Object)handle, (String)"peer"));
                            windows[0] = foundWindow;
                            return false;
                        }
                        return true;
                    }
                }, null);
                if (windows[0] != null) {
                    return windows[0];
                }
            } else {
                Pointer handle = user32.FindWindowW(null, new WString(title));
                if (handle != null) {
                    Window foundWindow = new Window();
                    foundWindow.handle = Long.toHexString((Long)ObjectUtil.getField((Object)handle, (String)"peer"));
                    foundWindow.title = title;
                    return foundWindow;
                }
            }
            if (System.currentTimeMillis() - start > (long)timeout) break;
            Thread.sleep(500L);
        }
        return null;
    }

    static interface User32
    extends StdCallLibrary {
        public static final User32 INSTANCE = (User32)Native.load((String)"user32", User32.class);

        public boolean EnumWindows(WNDENUMPROC var1, Pointer var2);

        public int GetWindowTextW(Pointer var1, char[] var2, int var3);

        public Pointer GetWindow(Pointer var1, int var2);

        public Pointer FindWindowW(WString var1, WString var2);

        public Boolean IsWindowVisible(Pointer var1);

        public static interface WNDENUMPROC
        extends StdCallLibrary.StdCallCallback {
            public boolean callback(Pointer var1, Pointer var2);
        }
    }

    public static class Window {
        public String title;
        public String handle;
    }
}

