/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FolderController
extends EntityController
implements Serializable {
    private static EntityController _instance;
    private static final long serialVersionUID = 5447512446375093789L;

    private FolderController() {
    }

    public static FolderController getInstance() {
        if (_instance == null) {
            _instance = new FolderController();
        }
        return (FolderController)_instance;
    }

    public List<FileEntity> getChildren(FolderEntity folder) throws ControllerException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getChildren(folder);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public List<String> getChildNames(FolderEntity folder) throws Exception {
        ArrayList<String> childNames = new ArrayList<String>();
        for (FileEntity child : this.getChildren(folder)) {
            childNames.add(child.getName());
        }
        return childNames;
    }

    public List<String> getRootFileOrFolderNames(ProjectEntity project) {
        File projectFolder = new File(project.getFolderLocation());
        return Arrays.asList(projectFolder.listFiles()).stream().map(f -> f.getName()).collect(Collectors.toList());
    }

    public List<TestCaseEntity> getTestCaseChildren(FolderEntity parentFolder) throws ControllerException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getTestCaseChildren(parentFolder);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public List<Object> getAllDescentdantEntities(FolderEntity folder) throws Exception {
        ArrayList<Object> allDescendant = new ArrayList<Object>();
        for (FileEntity child : this.getChildren(folder)) {
            if (child instanceof FolderEntity) {
                allDescendant.addAll(this.getAllDescentdantEntities((FolderEntity)child));
            }
            allDescendant.add(child);
        }
        return allDescendant;
    }

    public List<FolderEntity> getChildFolders(FolderEntity parentFolder) throws ControllerException {
        try {
            List childrenEntities = FolderController.getDataProviderSetting().getFolderDataProvider().getChildren(parentFolder);
            ArrayList<FolderEntity> childrentFolders = new ArrayList<FolderEntity>();
            for (FileEntity entity : childrenEntities) {
                if (!(entity instanceof FolderEntity)) continue;
                childrentFolders.add((FolderEntity)entity);
            }
            return childrentFolders;
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public FolderEntity getTestSuiteRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getTestSuiteRoot(project);
    }

    public FolderEntity getTestCaseRoot(ProjectEntity project) throws ControllerException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getTestCaseRoot(project);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public FolderEntity getTestDataRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getTestDataRoot(project);
    }

    public FolderEntity getObjectRepositoryRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getObjectRepositoryRoot(project);
    }

    public FolderEntity getKeywordRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getKeywordRoot(project);
    }

    public FolderEntity getReportRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getReportRoot(project);
    }

    public FolderEntity getTestListenerRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getTestListenerRoot(project);
    }

    public FolderEntity getCheckpointRoot(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getCheckpointRoot(project);
    }

    public List<FileEntity> getRootUserFilesOrFolders(ProjectEntity project) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getRootUserFilesOrFolders(project);
    }

    public void deleteFolder(FolderEntity folder) throws Exception {
        FolderController.getDataProviderSetting().getFolderDataProvider().deleteFolder(folder);
    }

    public FolderEntity addNewFolder(FolderEntity parentFolder, String folderName) throws ControllerException, FilePathTooLongException {
        if (parentFolder != null) {
            try {
                return FolderController.getDataProviderSetting().getFolderDataProvider().addNewFolder(parentFolder, folderName);
            }
            catch (FilePathTooLongException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ControllerException(e);
            }
        }
        return null;
    }

    public FolderEntity addNewRootFolder(ProjectEntity project, String folderName) throws ControllerException, FilePathTooLongException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().addNewRootFolder(project, folderName);
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public void updateFolderName(FolderEntity folder, String newName) throws Exception {
        FolderController.getDataProviderSetting().getFolderDataProvider().updateFolderName(folder, newName);
    }

    public FolderEntity copyFolder(FolderEntity folder, FolderEntity targetFolder) throws Exception {
        if (targetFolder != null && folder != null && folder.getFolderType() == targetFolder.getFolderType()) {
            return FolderController.getDataProviderSetting().getFolderDataProvider().copyFolder(folder, targetFolder);
        }
        return null;
    }

    public FolderEntity moveFolder(FolderEntity folder, FolderEntity targetFolder) throws Exception {
        if (targetFolder != null && folder != null && folder.getFolderType() == targetFolder.getFolderType()) {
            return FolderController.getDataProviderSetting().getFolderDataProvider().moveFolder(folder, targetFolder);
        }
        return null;
    }

    public FolderEntity getFolder(String folderValue) throws Exception {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getFolder(folderValue);
    }

    public FolderEntity getFolderByDisplayId(ProjectEntity projectEntity, String folderDisplayId) throws ControllerException {
        if (folderDisplayId == null || folderDisplayId.isEmpty()) {
            return null;
        }
        String folderId = projectEntity.getFolderLocation() + File.separator + folderDisplayId.replace("/", File.separator);
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getFolder(folderId);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public List<String> getSibblingFolderNames(FolderEntity folder) throws Exception {
        List<FolderEntity> sibblingFolders = this.getChildFolders(folder.getParentFolder());
        ArrayList<String> sibblingName = new ArrayList<String>();
        for (FolderEntity sibblingFolder : sibblingFolders) {
            if (FolderController.getDataProviderSetting().getEntityPk((Entity)sibblingFolder).equals(FolderController.getDataProviderSetting().getEntityPk((Entity)folder))) continue;
            sibblingName.add(sibblingFolder.getName());
        }
        return sibblingName;
    }

    public List<String> getChildrenNames(FolderEntity folder) throws Exception {
        List<FileEntity> children = this.getChildren(folder);
        ArrayList<String> childrenNames = new ArrayList<String>();
        for (FileEntity child : children) {
            childrenNames.add(child.getName());
        }
        return childrenNames;
    }

    public void loadAllDescentdantEntities(FolderEntity folder) throws Exception {
        List<FileEntity> childrenEntities = this.getChildren(folder);
        if (childrenEntities != null) {
            folder.setChildrenEntities(childrenEntities);
            for (FileEntity object : childrenEntities) {
                if (object instanceof FolderEntity) {
                    this.loadAllDescentdantEntities((FolderEntity)object);
                    continue;
                }
                if (!(object instanceof TestCaseEntity)) continue;
                GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)((TestCaseEntity)object));
            }
        }
    }

    public boolean isFolderAncestorOfEntity(FolderEntity folder, IEntity entity) throws Exception {
        return entity.getId().contains(folder.getId() + File.separator);
    }

    public void refreshFolder(FolderEntity folder) throws Exception {
        FolderController.getDataProviderSetting().getFolderDataProvider().refreshFolder(folder);
    }

    @Deprecated
    public String getIdForDisplay(FolderEntity folder) {
        return folder.getRelativePathForUI().replace(File.separator, "/");
    }

    public void saveFolder(FolderEntity folder) throws Exception {
        FolderController.getDataProviderSetting().getFolderDataProvider().saveFolder(folder);
    }

    public void saveParentFolderRecursively(FolderEntity folder) throws Exception {
        FolderController.getDataProviderSetting().getFolderDataProvider().saveFolder(folder);
        if (folder.getParentFolder() != null) {
            this.saveParentFolderRecursively(folder.getParentFolder());
        }
    }

    public String getAvailableFolderName(FolderEntity parentFolder, String name) throws ControllerException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getAvailableFolderName(parentFolder, name);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public FolderEntity getProfileRoot(ProjectEntity project) throws DALException {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getProfileRoot(project);
    }

    public FolderEntity getIncludeRoot(ProjectEntity project) throws DALException {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getIncludeRoot(project);
    }

    public FolderEntity getFeatureRoot(ProjectEntity project) throws ControllerException {
        try {
            return FolderController.getDataProviderSetting().getFolderDataProvider().getFeatureRoot(project);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public FolderEntity getGroovyScriptRoot(ProjectEntity project) throws DALException {
        return FolderController.getDataProviderSetting().getFolderDataProvider().getGroovyScriptRoot(project);
    }

    public boolean isSourceFolder(ProjectEntity project, FolderEntity folderEntity) {
        List sourceFolders = project.getSourceContent().getSourceFolderList().stream().map(source -> source.getUrl()).collect(Collectors.toList());
        return folderEntity.getFolderType() == FolderEntity.FolderType.INCLUDE && sourceFolders.contains(StringUtils.replace((String)folderEntity.getRelativePath(), (String)"\\", (String)"/"));
    }

    public boolean isSystemFolder(ProjectEntity project, FolderEntity folderEntity) {
        List systemFolder = project.getSourceContent().getSystemFolderList().stream().map(source -> source.getUrl()).collect(Collectors.toList());
        return folderEntity.getFolderType() == FolderEntity.FolderType.INCLUDE && systemFolder.contains(folderEntity.getRelativePath());
    }

    public boolean isAncentorSystemFolder(ProjectEntity project, FolderEntity folderEntity) {
        List systemFolder = project.getSourceContent().getSystemFolderList().stream().map(source -> source.getUrl()).collect(Collectors.toList());
        String folderRelativePath = folderEntity.getRelativePath();
        return folderEntity.getFolderType() == FolderEntity.FolderType.INCLUDE && systemFolder.stream().filter(s -> s.equals(folderRelativePath) || s.startsWith(folderRelativePath + "/")).findAny().isPresent();
    }
}

