/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TestSuiteController
extends EntityController {
    private static EntityController _instance;

    private TestSuiteController() {
    }

    public static TestSuiteController getInstance() {
        if (_instance == null) {
            _instance = new TestSuiteController();
        }
        return (TestSuiteController)_instance;
    }

    public TestSuiteEntity newTestSuite(FolderEntity parentFolder, String testSuiteName) throws Exception {
        return this.saveNewTestSuite(this.newTestSuiteWithoutSave(parentFolder, testSuiteName));
    }

    public TestSuiteEntity newTestSuiteWithoutSave(FolderEntity parentFolder, String testSuiteName) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)testSuiteName)) {
            testSuiteName = StringConstants.CTRL_NEW_TEST_SUITE;
        }
        TestSuiteEntity newTestSuite = new TestSuiteEntity();
        newTestSuite.setTestSuiteGuid(Util.generateGuid());
        newTestSuite.setName(this.getAvailableTestSuiteName(parentFolder, testSuiteName));
        newTestSuite.setParentFolder(parentFolder);
        newTestSuite.setProject(parentFolder.getProject());
        return newTestSuite;
    }

    public FilteringTestSuiteEntity newFilteringTestSuiteWithoutSave(FolderEntity parentFolder, String testSuiteName) throws DALException {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)testSuiteName)) {
            testSuiteName = StringConstants.CTRL_NEW_TEST_SUITE;
        }
        FilteringTestSuiteEntity newTestSuite = new FilteringTestSuiteEntity();
        newTestSuite.setTestSuiteGuid(Util.generateGuid());
        try {
            newTestSuite.setName(this.getAvailableTestSuiteName(parentFolder, testSuiteName));
        }
        catch (Exception e) {
            throw new DALException(e);
        }
        newTestSuite.setParentFolder(parentFolder);
        newTestSuite.setProject(parentFolder.getProject());
        newTestSuite.setFilteringText("");
        return newTestSuite;
    }

    public TestSuiteEntity saveNewTestSuite(TestSuiteEntity newTestSuite) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().saveNewTestSuite(newTestSuite);
    }

    public void deleteTestSuite(TestSuiteEntity testSuite) throws Exception {
        TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().deleteTestSuite(testSuite);
    }

    public synchronized TestSuiteEntity updateTestSuite(TestSuiteEntity testSuite) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().updateTestSuite(testSuite);
    }

    public TestSuiteEntity renameTestSuite(String newName, TestSuiteEntity testSuite) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().renameTestSuite(newName, testSuite);
    }

    public TestSuiteEntity copyTestSuite(TestSuiteEntity testSuite, FolderEntity targetFolder) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().copyTestSuite(testSuite, targetFolder);
    }

    public TestSuiteEntity moveTestSuite(TestSuiteEntity testSuite, FolderEntity targetFolder) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().moveTestSuite(testSuite, targetFolder);
    }

    @Deprecated
    public String getIdForDisplay(TestSuiteEntity entity) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getIdForDisplay(entity).replace(File.separator, "/");
    }

    public TestSuiteEntity getTestSuiteByDisplayId(String testSuiteId, ProjectEntity projectEntity) throws Exception {
        String testSuitePk = projectEntity.getFolderLocation() + File.separator + testSuiteId.replace("/", File.separator) + TestSuiteEntity.getTestSuiteFileExtension();
        return this.getTestSuite(testSuitePk);
    }

    public TestSuiteEntity getTestSuiteByTestSuitePartId(String elementId) throws Exception {
        String testSuitePkWithDoubleBrackets = elementId.replaceFirst("com.kms.katalon.composer.content.testsuite", "");
        String testSuitePk = testSuitePkWithDoubleBrackets.substring(1, testSuitePkWithDoubleBrackets.length() - 1);
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getTestSuite(testSuitePk);
    }

    public List<String> getSibblingTestSuiteNames(TestSuiteEntity testSuite) throws Exception {
        List<FileEntity> sibblingEntities = FolderController.getInstance().getChildren(testSuite.getParentFolder());
        ArrayList<String> sibblingName = new ArrayList<String>();
        for (FileEntity sibblingEntity : sibblingEntities) {
            if (!(sibblingEntity instanceof TestSuiteEntity) || TestSuiteController.getDataProviderSetting().getEntityPk((Entity)sibblingEntity).equals(TestSuiteController.getDataProviderSetting().getEntityPk((Entity)testSuite))) continue;
            sibblingName.add(sibblingEntity.getName());
        }
        return sibblingName;
    }

    public List<TestSuiteTestCaseLink> getTestSuiteTestCaseRun(TestSuiteEntity testSuite) {
        ArrayList<TestSuiteTestCaseLink> runnableTestCases = new ArrayList<TestSuiteTestCaseLink>();
        for (TestSuiteTestCaseLink link : testSuite.getTestSuiteTestCaseLinks()) {
            if (!link.getIsRun()) continue;
            runnableTestCases.add(link);
        }
        return runnableTestCases;
    }

    public VariableEntity getVariable(TestSuiteTestCaseLink testCaseLink, VariableLink variableLink) throws Exception {
        String testCaseId = testCaseLink.getTestCaseId();
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        if (testCase != null) {
            return TestCaseController.getInstance().getVariable(testCase, variableLink.getVariableId());
        }
        return null;
    }

    public VariableEntity getVariable(String testCaseId, VariableLink variableLink) throws Exception {
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        return testCase != null ? TestCaseController.getInstance().getVariable(testCase, variableLink.getVariableId()) : null;
    }

    public List<TestCaseTestDataLink> getTestDataLinkUsedInTestCase(TestSuiteTestCaseLink testCaseLink) {
        ArrayList<TestCaseTestDataLink> testDataLinkUsed = new ArrayList<TestCaseTestDataLink>();
        HashMap<String, TestCaseTestDataLink> testDataLinkMap = new HashMap<String, TestCaseTestDataLink>();
        for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
            testDataLinkMap.put(testDataLink.getId(), testDataLink);
        }
        for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
            String testDataLinkId;
            TestCaseTestDataLink testDataLink;
            if (variableLink.getType() == VariableLink.VariableType.DEFAULT || variableLink.getTestDataLinkId() == null || variableLink.getValue() == null || (testDataLink = (TestCaseTestDataLink)testDataLinkMap.get(testDataLinkId = variableLink.getTestDataLinkId())) == null || testDataLinkUsed.contains(testDataLink)) continue;
            testDataLinkUsed.add(testDataLink);
        }
        return testDataLinkUsed;
    }

    public String[] mailRcpStringToArray(String mailRcpString) {
        if (mailRcpString != null && !mailRcpString.isEmpty()) {
            return mailRcpString.split(";");
        }
        return new String[0];
    }

    public String arrayMailRcpToString(String[] mailRcpArray) {
        StringBuilder builder = new StringBuilder("");
        String[] stringArray = mailRcpArray;
        int n = mailRcpArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mailRcp = stringArray[n2];
            builder.append(mailRcp + ";");
            ++n2;
        }
        return builder.toString();
    }

    public TestSuiteEntity getTestSuite(String testSuitePk) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getTestSuite(testSuitePk);
    }

    public TestCaseTestDataLink getTestDataLink(String testDataLinkId, TestSuiteTestCaseLink testCaseLink) {
        for (TestCaseTestDataLink dataLink : testCaseLink.getTestDataLinks()) {
            if (!dataLink.getId().equals(testDataLinkId)) continue;
            return dataLink;
        }
        return null;
    }

    public String getAvailableTestSuiteName(FolderEntity parentFolder, String name) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getAvailableTestSuiteName(parentFolder, name);
    }

    public List<TestSuiteTestCaseLink> getTestCaseLink(String testCaseId, TestSuiteEntity testSuite) {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getTestCaseLink(testSuite, testCaseId);
    }

    public void reloadTestSuite(TestSuiteEntity testSuite, Entity entity) throws Exception {
        testSuite = this.getTestSuite(entity.getId());
        entity = testSuite;
    }

    public List<TestSuiteCollectionEntity> getTestSuiteCollectionReferences(TestSuiteEntity testSuite) throws DALException {
        return TestSuiteController.getDataProviderSetting().getTestSuiteCollectionDataProvider().getTestSuiteCollectionReferences(testSuite, ProjectController.getInstance().getCurrentProject());
    }

    public void removeTestSuiteCollectionReferences(TestSuiteEntity testSuite, List<TestSuiteCollectionEntity> testSuiteCollectionReferences) throws DALException {
        TestSuiteController.getDataProviderSetting().getTestSuiteCollectionDataProvider().removeTestSuiteCollectionReferences(testSuite, testSuiteCollectionReferences);
    }

    public File getTestSuiteScriptFile(TestSuiteEntity testSuite) throws DALException {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getTestSuiteScriptFile(testSuite);
    }

    public File newTestSuiteScriptFile(TestSuiteEntity testSuite) throws DALException {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().newTestSuiteScriptFile(testSuite);
    }

    public List<TestSuiteEntity> getAllTestSuites(ProjectEntity project) throws Exception {
        return TestSuiteController.getDataProviderSetting().getTestSuiteDataProvider().getAll(project);
    }

    public TestSuiteEntity getTestSuiteByName(String testSuiteName, ProjectEntity project) throws Exception {
        List<TestSuiteEntity> testSuiteList = this.getAllTestSuites(project);
        Optional<TestSuiteEntity> tsEntity = testSuiteList.stream().filter(testSuite -> testSuite.getName().equals(testSuiteName)).findFirst();
        return tsEntity.orElse(null);
    }
}

