/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.ast.editors.InputCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.MethodComboBoxCellEditor;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputParameterBuilder;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class MethodCallInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultObjectValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.MethodCall);
    private MethodCallExpressionWrapper methodCallExpression;
    private ClassLoader classLoader;

    public MethodCallInputBuilderDialog(Shell parentShell, MethodCallExpressionWrapper methodCallExpression) {
        super(parentShell);
        this.methodCallExpression = methodCallExpression.clone();
        this.classLoader = this.getClassLoader();
    }

    private ClassLoader getClassLoader() {
        try {
            return ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
        }
        catch (MalformedURLException | CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public ASTNodeWrapper getReturnValue() {
        return this.methodCallExpression;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_METHOD_CALL_INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumnObjectType();
        this.addTableColumnObject();
        this.addTableColumnMethod();
        this.addTableColumnInput();
    }

    private void addTableColumnObjectType() {
        TableViewerColumn tableViewerColumnObjectType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnObjectType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_OBJ_TYPE);
        tableViewerColumnObjectType.getColumn().setWidth(100);
        tableViewerColumnObjectType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == MethodCallInputBuilderDialog.this.methodCallExpression) {
                    return super.getText(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
                }
                return "";
            }
        });
        tableViewerColumnObjectType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultObjectValueTypes){

            @Override
            protected Object getValue(Object element) {
                return super.getValue(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression(), value);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element == MethodCallInputBuilderDialog.this.methodCallExpression && super.canEdit(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }
        });
    }

    private void addTableColumnObject() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnClass = tableViewerColumnObject.getColumn();
        tblclmnNewColumnClass.setText(GlobalMessageConstants.OBJECT);
        tblclmnNewColumnClass.setWidth(152);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == MethodCallInputBuilderDialog.this.methodCallExpression) {
                    return super.getText(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
                }
                return "";
            }
        });
        tableViewerColumnObject.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected Object getValue(Object element) {
                return super.getValue(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression(), value);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element == MethodCallInputBuilderDialog.this.methodCallExpression && super.canEdit(MethodCallInputBuilderDialog.this.methodCallExpression.getObjectExpression());
            }

            @Override
            protected void handleUpdateInputSuccessfully() {
                MethodCallInputBuilderDialog.this.resetDefaultMethod(MethodCallInputBuilderDialog.this.methodCallExpression);
                super.handleUpdateInputSuccessfully();
            }
        });
    }

    private void addTableColumnMethod() {
        TableViewerColumn tableViewerColumnMethod = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnMethod = tableViewerColumnMethod.getColumn();
        tblclmnNewColumnMethod.setText(ComposerTestcaseMessageConstants.DIA_COL_METHOD);
        tblclmnNewColumnMethod.setWidth(152);
        tableViewerColumnMethod.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == MethodCallInputBuilderDialog.this.methodCallExpression) {
                    return MethodCallInputBuilderDialog.this.methodCallExpression.getMethodAsString();
                }
                return "";
            }
        });
        tableViewerColumnMethod.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (value instanceof Method) {
                    Method newMethod = (Method)value;
                    if (MethodComboBoxCellEditor.compareMethodAndMethodCall(newMethod, MethodCallInputBuilderDialog.this.methodCallExpression, MethodCallInputBuilderDialog.this.classLoader) == MethodComboBoxCellEditor.MethodComparation.EQUAL_NAME_AND_PARAM) {
                        return;
                    }
                    MethodCallInputBuilderDialog.this.methodCallExpression.setMethod(newMethod.getName());
                    AstKeywordsInputUtil.generateMethodCallArguments(MethodCallInputBuilderDialog.this.methodCallExpression, newMethod);
                    this.getViewer().refresh();
                }
            }

            protected Object getValue(Object element) {
                return MethodCallInputBuilderDialog.this.methodCallExpression;
            }

            protected CellEditor getCellEditor(Object element) {
                if (MethodCallInputBuilderDialog.this.classLoader == null) {
                    return null;
                }
                MethodComboBoxCellEditor cellEditor = new MethodComboBoxCellEditor((Composite)MethodCallInputBuilderDialog.this.tableViewer.getTable(), MethodCallInputBuilderDialog.this.getObjectType(MethodCallInputBuilderDialog.this.methodCallExpression), MethodCallInputBuilderDialog.this.methodCallExpression.isStaticMethodCall(MethodCallInputBuilderDialog.this.classLoader), MethodCallInputBuilderDialog.this.classLoader);
                MethodCallInputBuilderDialog.this.processAutoSuggestion(cellEditor);
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return element == MethodCallInputBuilderDialog.this.methodCallExpression;
            }
        });
    }

    private void processAutoSuggestion(MethodComboBoxCellEditor cellEditor) {
        KeyAdapter keyAdapter = new KeyAdapter(){
            private org.eclipse.swt.widgets.List listItem = null;

            public void keyReleased(KeyEvent ke) {
                if (ke.keyCode == 0x1000001 || ke.keyCode == 0x1000002) {
                    return;
                }
                CCombo combo = (CCombo)ke.getSource();
                if (!(combo.getDisplay().getFocusControl() instanceof Text)) {
                    return;
                }
                Text textControl = (Text)combo.getDisplay().getFocusControl();
                if (combo.getItemCount() <= 0) {
                    return;
                }
                combo.setListVisible(true);
                String[] items = combo.getItems();
                String curText = textControl.getText();
                int selectIndex = -1;
                int i = 0;
                while (i < items.length && curText.length() > 0) {
                    if (this.getMethodName(items[i]).startsWith(curText)) {
                        selectIndex = i;
                        break;
                    }
                    ++i;
                }
                Control focusControl = combo.getDisplay().getFocusControl();
                if (focusControl instanceof org.eclipse.swt.widgets.List) {
                    focusControl.removeListener(16, focusControl.getListeners(16)[0]);
                    this.listItem = (org.eclipse.swt.widgets.List)focusControl;
                }
                if (this.listItem != null) {
                    this.listItem.setSelection(selectIndex);
                }
                textControl.setFocus();
            }

            private String getMethodName(String item) {
                if (item.contains("(")) {
                    return item.substring(0, item.indexOf("("));
                }
                return item;
            }
        };
        cellEditor.getControl().addKeyListener((KeyListener)keyAdapter);
    }

    private void addTableColumnInput() {
        TableViewerColumn tableViewerColumnInput = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnInput = tableViewerColumnInput.getColumn();
        tblclmnNewColumnInput.setText(GlobalMessageConstants.INPUT);
        tblclmnNewColumnInput.setWidth(170);
        tableViewerColumnInput.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == MethodCallInputBuilderDialog.this.methodCallExpression) {
                    return MethodCallInputBuilderDialog.this.methodCallExpression.getArguments().getText();
                }
                return "";
            }
        });
        tableViewerColumnInput.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (!(value instanceof InputParameterBuilder)) {
                    return;
                }
                ArgumentListExpressionWrapper argumentListExpression = new ArgumentListExpressionWrapper((ASTNodeWrapper)MethodCallInputBuilderDialog.this.methodCallExpression);
                for (InputParameter inputParameter : ((InputParameterBuilder)value).getOriginalParameters()) {
                    argumentListExpression.addExpression(inputParameter.getValueAsExpression());
                }
                MethodCallInputBuilderDialog.this.methodCallExpression.setArguments(argumentListExpression);
                MethodCallInputBuilderDialog.this.tableViewer.refresh();
            }

            protected Object getValue(Object element) {
                Method method = MethodCallInputBuilderDialog.this.findMethod(MethodCallInputBuilderDialog.this.getObjectType(MethodCallInputBuilderDialog.this.methodCallExpression), MethodCallInputBuilderDialog.this.methodCallExpression);
                List<InputParameter> inputParameters = new ArrayList<InputParameter>();
                if (method != null) {
                    inputParameters = AstKeywordsInputUtil.generateInputParameters(method, MethodCallInputBuilderDialog.this.methodCallExpression.getArguments());
                }
                return InputParameterBuilder.createForNestedMethodCall(inputParameters);
            }

            protected CellEditor getCellEditor(Object element) {
                return new InputCellEditor((Composite)MethodCallInputBuilderDialog.this.tableViewer.getTable(), MethodCallInputBuilderDialog.this.methodCallExpression.getArguments().getText(), MethodCallInputBuilderDialog.this.methodCallExpression.getArguments());
            }

            protected boolean canEdit(Object element) {
                return element == MethodCallInputBuilderDialog.this.methodCallExpression && MethodComboBoxCellEditor.getMethodCallParams(MethodCallInputBuilderDialog.this.methodCallExpression, MethodCallInputBuilderDialog.this.classLoader).length > 0;
            }
        });
    }

    public void resetDefaultMethod(MethodCallExpressionWrapper methodCall) {
        Class<?> type = this.getObjectType(methodCall);
        if (type != null && type.getMethods().length > 0) {
            Method methodNode = type.getMethods()[0];
            methodCall.setMethod(methodNode.getName());
            AstKeywordsInputUtil.generateMethodCallArguments(methodCall, methodNode);
            return;
        }
        methodCall.setMethod("toString");
        methodCall.setArguments(new ArgumentListExpressionWrapper((ASTNodeWrapper)methodCall));
    }

    public Class<?> getObjectType(MethodCallExpressionWrapper methodCall) {
        return this.classLoader != null ? methodCall.resolveType(this.classLoader) : null;
    }

    private Method findMethod(Class<?> type, MethodCallExpressionWrapper methodCall) {
        if (methodCall == null) {
            return null;
        }
        Method method = null;
        if (type != null) {
            method = this.findMatchingMethod(type, methodCall);
        }
        if (method == null) {
            return this.findMatchingMethod(DefaultGroovyMethods.class, methodCall);
        }
        return method;
    }

    private Method findMatchingMethod(Class<?> type, MethodCallExpressionWrapper methodCall) {
        Method[] methods = type.getMethods();
        int index = 0;
        while (index < methods.length) {
            Method methodNode = methods[index];
            if (MethodComboBoxCellEditor.compareMethodAndMethodCall(methodNode, methodCall, this.classLoader) == MethodComboBoxCellEditor.MethodComparation.EQUAL_NAME_AND_PARAM) {
                return methodNode;
            }
            ++index;
        }
        return null;
    }

    @Override
    public void setInput() {
        ArrayList<MethodCallExpressionWrapper> expressionList = new ArrayList<MethodCallExpressionWrapper>();
        expressionList.add(this.methodCallExpression);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(expressionList);
        this.tableViewer.refresh();
    }
}

