/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.control.Dropdown;
import com.kms.katalon.composer.components.impl.control.DropdownGroup;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.IVariablePart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableView;
import com.kms.katalon.composer.testcase.preferences.RecentObjectStorage;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.FrameworkUtil;

public class TestObjectBuilderDialog
extends TreeEntitySelectionDialog
implements IAstDialogBuilder {
    private static final int TOOL_ITEM_SIZE = 50;
    private static final InputValueType[] defaultInputValueTypes = new InputValueType[]{InputValueType.Variable, InputValueType.GlobalVariable};
    private static final InputValueType[] defaultVariableInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Map);
    private static final InputValueType[] webServiceRequestVariableInputValueTypes = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.Property, InputValueType.List, InputValueType.Map};
    private static final String DEFAULT_VARIABLE_NAME = "variable";
    private static final String pluginId = FrameworkUtil.getBundle(TestObjectBuilderDialog.class).getSymbolicName();
    private static final String OBJECT_FINDER_TAB_NAME = TreeEntityUtil.getReadableKeywordName((String)InputValueType.TestObject.getName());
    private static final String[] TEST_OBJECT_TABS = new String[]{OBJECT_FINDER_TAB_NAME, ComposerTestcaseMessageConstants.DIA_TAB_OTHER};
    private TestObjectBuilderDialog _instance = this;
    private TableViewer tableViewer;
    private ExpressionWrapper objectExpressionWrapper;
    private boolean haveOtherTypes;
    private StackLayout stackLayout;
    private SashForm objectFinderComposite;
    private Composite otherTypesInputTableComposite;
    private Composite comboComposite;
    private Composite webServiceVariablesComposite;
    private Composite testObjectVariablesComposite;
    private Combo combo;
    private Label lblVariables;
    private Composite compositeVariables;
    private Composite compositeVariablesDetails;
    private StackLayout compositeVariablesDetailsLayout;
    private TableViewer variableTableViewer;
    private IVariablePart webServiceRequestVariablesPart;
    private TestCaseVariableView webServiceRequestVariablesView;
    private MapExpressionWrapper variableMaps = null;
    private WebElementEntity initialSelectedTestObject = null;
    private WebElementEntity selectedWebElement = null;
    private List<VariableEntity> initialRequestVariables = null;
    private List<MapEntryExpressionWrapper> initialVariableMapEntries = null;
    private ITestCasePart testCasePart;
    private ToolItem recentTestObjectItem;
    private Dropdown recentTestObjectDropdown;

    public TestObjectBuilderDialog(Shell parentShell, ExpressionWrapper objectExpressionWrapper, boolean haveOtherTypes) {
        super(parentShell, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
        this.haveOtherTypes = haveOtherTypes;
        this.objectExpressionWrapper = objectExpressionWrapper.clone();
        this.initVariableMap();
        this.setAllowMultiple(false);
        this.setShellStyle(0x10860 | TestObjectBuilderDialog.getDefaultOrientation() | 0x10);
        try {
            this.setInput(TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject())));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.refreshSelectionTree();
        if (this.initialSelectedTestObject instanceof WebServiceRequestEntity) {
            List<MapEntryExpressionWrapper> variables = this.variableMaps.getMapEntryExpressions();
            this.initialRequestVariables = variables.stream().map(variable -> {
                VariableEntity variableEntity = new VariableEntity();
                String variableName = variable.getKeyExpression().getText();
                variableName = variableName.replaceAll("^\"|\"$", "");
                variableEntity.setName(variableName);
                String variableValue = variable.getValueExpression().getText();
                variableEntity.setDefaultValue(variableValue);
                return variableEntity;
            }).collect(Collectors.toList());
        } else {
            this.initialVariableMapEntries = new ArrayList<MapEntryExpressionWrapper>(this.variableMaps != null ? this.variableMaps.getMapEntryExpressions() : new ArrayList());
        }
    }

    public void setTestCasePart(ITestCasePart testCasePart) {
        this.testCasePart = testCasePart;
    }

    public ITestCasePart getTestCasePart() {
        return this.testCasePart;
    }

    private void initVariableMap() {
        if (!this.isObjectExpressionFindTestObjectMethodCall()) {
            return;
        }
        MethodCallExpressionWrapper methodCallObjectExpression = (MethodCallExpressionWrapper)this.objectExpressionWrapper;
        if (methodCallObjectExpression.getArguments().getExpressions().size() <= 1) {
            this.variableMaps = new MapExpressionWrapper((ASTNodeWrapper)methodCallObjectExpression.getArguments());
            return;
        }
        ExpressionWrapper secondParam = methodCallObjectExpression.getArguments().getExpressions().get(1);
        if (!(secondParam instanceof MapExpressionWrapper)) {
            this.variableMaps = new MapExpressionWrapper((ASTNodeWrapper)methodCallObjectExpression.getArguments());
            return;
        }
        this.variableMaps = (MapExpressionWrapper)secondParam;
    }

    protected void refreshSelectionTree() {
        String testObjectId = null;
        if (this.isObjectExpressionFindTestObjectMethodCall()) {
            testObjectId = AstEntityInputUtil.findTestObjectIdFromFindTestObjectMethodCall((MethodCallExpressionWrapper)this.objectExpressionWrapper);
        }
        if (testObjectId == null) {
            return;
        }
        WebElementEntity selectedWebElement = null;
        FolderEntity objectRepositoryRoot = null;
        try {
            selectedWebElement = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
            objectRepositoryRoot = FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (selectedWebElement == null || objectRepositoryRoot == null) {
            return;
        }
        this.setInitialSelection(new WebElementTreeEntity(selectedWebElement, (ITreeEntity)TestObjectBuilderDialog.createSelectedTreeEntityHierachy(selectedWebElement.getParentFolder(), objectRepositoryRoot)));
        this.initialSelectedTestObject = selectedWebElement;
    }

    private void createTopCompiste(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        topComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.comboComposite = new Composite(topComposite, 0);
        this.comboComposite.setLayout((Layout)new GridLayout(2, false));
        Label comboLabel = new Label(this.comboComposite, 0);
        comboLabel.setText(ComposerTestcaseMessageConstants.DIA_COL_OBJ_TYPE);
        this.combo = new Combo(this.comboComposite, 4);
        this.combo.setItems(TEST_OBJECT_TABS);
        this.comboComposite.setVisible(this.haveOtherTypes);
        final ToolBar topToolbar = new ToolBar(topComposite, 0x820000);
        topToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        topToolbar.setTextDirection(0x2000000);
        topToolbar.setLayoutData((Object)new GridData(131072, 4, false, true));
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)topToolbar);
        this.recentTestObjectItem = new ToolItem(topToolbar, 4);
        this.recentTestObjectItem.setText(GlobalMessageConstants.RECENT);
        this.recentTestObjectItem.setImage(ImageConstants.IMG_16_RECENT);
        this.recentTestObjectDropdown = new Dropdown(this.getShell());
        this.createRecentDropdownItem();
        this.recentTestObjectDropdown.resizeToFitContent();
        this.recentTestObjectDropdown.setVisible(false);
        this.recentTestObjectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = TestObjectBuilderDialog.this.recentTestObjectItem.getBounds();
                Point recentTestObjectItemLocation = topToolbar.toDisplay(new Point(bounds.x, bounds.y));
                TestObjectBuilderDialog.this.recentTestObjectDropdown.setLocation(recentTestObjectItemLocation.x, recentTestObjectItemLocation.y + bounds.height);
                TestObjectBuilderDialog.this.recentTestObjectDropdown.setVisible(true);
            }
        });
        this.setTestObjectItemState();
    }

    private void createRecentDropdownItem() {
        List<String> recentObjectIds;
        RecentObjectStorage recentObjectStorage = this.getRecentObjectStorage();
        List<String> recentFolderIds = recentObjectStorage.getRecentFolderIds();
        if (!recentFolderIds.isEmpty()) {
            DropdownGroup recentFolderDropdownGrp = this.recentTestObjectDropdown.addDropdownGroupItem(GlobalMessageConstants.OBJECT_FOLDER, ImageConstants.IMG_16_FOLDER);
            recentFolderIds.forEach(recentFolderId -> this.createRecentFolderItem(recentFolderDropdownGrp, (String)recentFolderId));
        }
        if (!(recentObjectIds = recentObjectStorage.getRecentObjectIds()).isEmpty()) {
            DropdownGroup recentObjectDropdownGrp = this.recentTestObjectDropdown.addDropdownGroupItem(GlobalMessageConstants.TEST_OBJECT, ImageConstants.IMG_16_TEST_OBJECT);
            recentObjectIds.forEach(recentTestObjectId -> this.createRecentTestObjectItem(recentObjectDropdownGrp, (String)recentTestObjectId));
        }
    }

    private String getToolItemName(String rawName) {
        return StringUtils.substring((String)rawName, (int)0, (int)50);
    }

    private void createRecentTestObjectItem(DropdownGroup recentObjectDropdownGrp, String recentTestObjectId) {
        try {
            WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(recentTestObjectId);
            final WebElementTreeEntity webElementTreeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)testObject, (ProjectEntity)this.getCurrentProject());
            ToolItem toolItem = recentObjectDropdownGrp.addItem(this.getToolItemName(testObject.getName()), webElementTreeEntity.getImage(), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        TestObjectBuilderDialog.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)webElementTreeEntity));
                    }
                    catch (Exception exception) {}
                }
            });
            toolItem.setToolTipText(recentTestObjectId);
        }
        catch (Exception exception) {}
    }

    private void createRecentFolderItem(DropdownGroup recentFolderDropdownGrp, String recentFolderId) {
        try {
            FolderEntity folder = FolderController.getInstance().getFolderByDisplayId(this.getCurrentProject(), recentFolderId);
            final FolderTreeEntity folderTreeEntity = TreeEntityUtil.getWebElementFolderTreeEntity((FolderEntity)folder, (ProjectEntity)this.getCurrentProject());
            ToolItem toolItem = recentFolderDropdownGrp.addItem(this.getToolItemName(folder.getName()), folderTreeEntity.getImage(), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        TreeViewer treeViewer = TestObjectBuilderDialog.this.getTreeViewer();
                        treeViewer.setSelection((ISelection)new StructuredSelection((Object)folderTreeEntity));
                        treeViewer.setExpandedState((Object)folderTreeEntity, true);
                    }
                    catch (Exception exception) {}
                }
            });
            toolItem.setToolTipText(recentFolderId);
        }
        catch (Exception exception) {}
    }

    private void setTestObjectItemState() {
        this.recentTestObjectItem.setEnabled(!this.getRecentObjectStorage().isEmpty());
    }

    private RecentObjectStorage getRecentObjectStorage() {
        return TestCasePreferenceDefaultValueInitializer.getRecentObjectStorage(this.getCurrentProject());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createTopCompiste(container);
        Composite stackComposite = new Composite(container, 0);
        TestObjectBuilderDialog.applyDialogFont((Control)stackComposite);
        this.stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)this.stackLayout);
        stackComposite.setLayoutData((Object)new GridData(1808));
        this.objectFinderComposite = new SashForm(stackComposite, 512);
        this.objectFinderComposite.setLayout((Layout)new GridLayout(1, false));
        Composite treeComposite = new Composite((Composite)this.objectFinderComposite, 0);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer treeViewer = this.createTreeViewer(treeComposite);
        GridData data = new GridData(1808);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (TreeEntityUtil.isValidTreeEntitySelectionType((Object[])selection, (String)StringConstants.TREE_OBJECT_TYPE_NAME)) {
                    return new Status(0, pluginId, 0, null, null);
                }
                return new Status(4, pluginId, 4, null, null);
            }
        });
        treeWidget.setEnabled(true);
        this.createVariableComposite((Composite)this.objectFinderComposite);
        this.objectFinderComposite.setSashWidth(3);
        this.objectFinderComposite.setWeights(new int[]{6, 4});
        this.stackLayout.topControl = this.objectFinderComposite;
        if (this.haveOtherTypes) {
            this.createOtherTypesTab(stackComposite);
            if (this.isObjectExpressionFindTestObjectMethodCall()) {
                this.combo.select(0);
                this.stackLayout.topControl = this.objectFinderComposite;
            } else {
                this.combo.select(1);
                this.stackLayout.topControl = this.otherTypesInputTableComposite;
            }
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof TreeSelection)) {
                    return;
                }
                TreeSelection treeSelection = (TreeSelection)event.getSelection();
                Object selection = treeSelection.getFirstElement();
                if (!(selection instanceof ITreeEntity)) {
                    return;
                }
                if (!(selection instanceof WebElementTreeEntity)) {
                    TestObjectBuilderDialog.this.selectedWebElement = null;
                    TestObjectBuilderDialog.this.compositeVariablesDetailsLayout.topControl = null;
                } else {
                    WebElementEntity webElement;
                    try {
                        webElement = (WebElementEntity)((WebElementTreeEntity)selection).getObject();
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        return;
                    }
                    WebElementEntity previousSelectedElement = TestObjectBuilderDialog.this.selectedWebElement;
                    TestObjectBuilderDialog.this.selectedWebElement = webElement;
                    if (previousSelectedElement == TestObjectBuilderDialog.this.selectedWebElement) {
                        return;
                    }
                    TestObjectBuilderDialog.this.changeVariablesCompositeForSelectedEntity((WebElementTreeEntity)selection);
                }
            }
        });
        this.refresh();
        return container;
    }

    private void createVariableComposite(Composite parent) {
        this.compositeVariables = new Composite(parent, 0);
        this.compositeVariables.setBackground(ColorUtil.getCompositeBackgroundColor());
        GridLayout glCompositeExecution = new GridLayout(1, true);
        glCompositeExecution.verticalSpacing = 0;
        glCompositeExecution.horizontalSpacing = 0;
        glCompositeExecution.marginHeight = 0;
        glCompositeExecution.marginWidth = 0;
        this.compositeVariables.setLayout((Layout)glCompositeExecution);
        this.compositeVariables.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblVariables = new Label(this.compositeVariables, 0);
        GridData gdVariable = new GridData(16384, 128, false, false, 1, 1);
        gdVariable.horizontalIndent = 5;
        this.lblVariables.setLayoutData((Object)gdVariable);
        this.lblVariables.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.lblVariables.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_LABEL);
        this.compositeVariablesDetails = new Composite(this.compositeVariables, 0);
        this.compositeVariablesDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.compositeVariablesDetailsLayout = new StackLayout();
        this.compositeVariablesDetails.setLayout((Layout)this.compositeVariablesDetailsLayout);
        this.testObjectVariablesComposite = this.createTestObjectVariablesComposite(this.compositeVariablesDetails);
        this.webServiceVariablesComposite = this.createWebServiceObjectVariablesComposite(this.compositeVariablesDetails);
    }

    private void changeVariablesCompositeForSelectedEntity(WebElementTreeEntity treeEntity) {
        WebElementEntity entity;
        try {
            entity = (WebElementEntity)treeEntity.getObject();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return;
        }
        if (entity instanceof WebServiceRequestEntity) {
            this.changeVariablesCompositeForWebServiceObject((WebServiceRequestEntity)entity);
        } else {
            this.changeVariablesCompositeForTestObject(entity);
        }
        this.compositeVariablesDetails.getParent().layout(true, true);
    }

    private void changeVariablesCompositeForWebServiceObject(WebServiceRequestEntity requestEntity) {
        List<Object> variables = new ArrayList();
        variables = this.initialSelectedTestObject == requestEntity && !this.initialRequestVariables.isEmpty() ? this.initialRequestVariables.stream().map(VariableEntity::clone).collect(Collectors.toList()) : requestEntity.getVariables().stream().map(VariableEntity::clone).collect(Collectors.toList());
        this.webServiceRequestVariablesPart.deleteVariables(Arrays.asList(this.webServiceRequestVariablesPart.getVariables()));
        this.webServiceRequestVariablesPart.addVariables(variables.toArray(new VariableEntity[variables.size()]));
        this.compositeVariablesDetailsLayout.topControl = this.webServiceVariablesComposite;
    }

    private void changeVariablesCompositeForTestObject(WebElementEntity entity) {
        this.variableMaps.clearExpressions();
        if (this.initialSelectedTestObject == entity) {
            List<MapEntryExpressionWrapper> variableMapEntries = this.initialVariableMapEntries.stream().map(MapEntryExpressionWrapper::clone).collect(Collectors.toList());
            this.variableMaps.addExpressions(variableMapEntries);
        }
        this.compositeVariablesDetailsLayout.topControl = this.testObjectVariablesComposite;
        this.variableTableViewer.refresh();
    }

    private Composite createWebServiceObjectVariablesComposite(Composite parent) {
        TableColumn[] tableColumns;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.webServiceRequestVariablesPart = new IVariablePart(){

            @Override
            public void setDirty(boolean isDirty) {
            }

            @Override
            public void addVariables(VariableEntity[] variables) {
                TestObjectBuilderDialog.this.webServiceRequestVariablesView.addVariable(variables);
            }

            @Override
            public VariableEntity[] getVariables() {
                return TestObjectBuilderDialog.this.webServiceRequestVariablesView.getVariables();
            }

            @Override
            public void deleteVariables(List<VariableEntity> variableList) {
                TestObjectBuilderDialog.this.webServiceRequestVariablesView.deleteVariables(variableList);
            }
        };
        this.webServiceRequestVariablesView = new TestCaseVariableView(this.webServiceRequestVariablesPart);
        this.webServiceRequestVariablesView.setTestCasePart(this.testCasePart);
        this.webServiceRequestVariablesView.setInputValueTypes(webServiceRequestVariableInputValueTypes);
        this.webServiceRequestVariablesView.createComponents(composite);
        TableColumn[] tableColumnArray = tableColumns = this.webServiceRequestVariablesView.getTableViewer().getTable().getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (ComposerTestcaseMessageConstants.PA_COL_MASKED.equals(tableColumn.getText())) {
                tableColumn.setWidth(0);
                tableColumn.setResizable(false);
            }
            ++n2;
        }
        return composite;
    }

    private Composite createTestObjectVariablesComposite(Composite parent) {
        Composite composite = new Composite(this.compositeVariablesDetails, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestObjectBuilderDialog.this.addVariable();
            }
        });
        tltmAddVariable.setText(GlobalMessageConstants.ADD);
        tltmAddVariable.setImage(ImageConstants.IMG_16_ADD);
        final ToolItem tltmRemove = new ToolItem(toolBar, 0);
        tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestObjectBuilderDialog.this.removeVariables();
            }
        });
        tltmRemove.setText(GlobalMessageConstants.DELETE);
        tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        tltmRemove.setEnabled(false);
        ToolItem tltmClear = new ToolItem(toolBar, 0);
        tltmClear.setText(GlobalMessageConstants.CLEAR);
        tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestObjectBuilderDialog.this.clearVariables();
            }
        });
        this.variableTableViewer = new TableViewer(composite, 67586);
        ColumnViewerUtil.setTableActivation((TableViewer)this.variableTableViewer);
        this.variableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tltmRemove.setEnabled(!TestObjectBuilderDialog.this.variableTableViewer.getSelection().isEmpty());
            }
        });
        Table table = this.variableTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        GridData variableTableLayoutData = new GridData(4, 4, true, true, 1, 1);
        variableTableLayoutData.minimumHeight = 100;
        table.setLayoutData((Object)variableTableLayoutData);
        TableViewerColumn tableViewerColumnParamType = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnParamType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.variableTableViewer, defaultVariableInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
        TableColumn tblclmnParamType = tableViewerColumnParamType.getColumn();
        tblclmnParamType.setWidth(100);
        tblclmnParamType.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_PARAM_TYPE);
        tableViewerColumnParamType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnName.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.variableTableViewer){

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_PARAM);
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.variableTableViewer, defaultVariableInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
        TableColumn tblclmnValueType = tableViewerColumnValueType.getColumn();
        tblclmnValueType.setWidth(100);
        tblclmnValueType.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_VALUE_TYPE);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.variableTableViewer){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
        TableColumn tblclmnValue = tableViewerColumnValue.getColumn();
        tblclmnValue.setWidth(200);
        tblclmnValue.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_VALUE);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        this.variableTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.variableTableViewer.setInput(this.variableMaps != null ? this.variableMaps.getMapEntryExpressions() : Collections.emptyMap());
        return composite;
    }

    private void clearVariables() {
        this.variableMaps.clearExpressions();
        this.variableTableViewer.refresh();
    }

    private void removeVariables() {
        StructuredSelection selection = (StructuredSelection)this.variableTableViewer.getSelection();
        Object[] selectionElements = selection.toArray();
        if (selectionElements.length == 0) {
            return;
        }
        Object[] objectArray = selectionElements;
        int n = selectionElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof MapEntryExpressionWrapper) {
                this.variableMaps.removeExpression((MapEntryExpressionWrapper)object);
            }
            ++n2;
        }
        this.variableTableViewer.refresh();
    }

    private void addVariable() {
        MapEntryExpressionWrapper newMapEntry = new MapEntryExpressionWrapper((ASTNodeWrapper)this.variableMaps);
        newMapEntry.setKeyExpression(new ConstantExpressionWrapper(this.generateNewPropertyName(), (ASTNodeWrapper)newMapEntry));
        newMapEntry.setValueExpression(new ConstantExpressionWrapper("", (ASTNodeWrapper)newMapEntry));
        this.variableMaps.addExpression(newMapEntry);
        this.variableTableViewer.refresh();
    }

    private String generateNewPropertyName() {
        String name = DEFAULT_VARIABLE_NAME;
        int index = 0;
        boolean isUnique = false;
        Object newName = name;
        while (!isUnique) {
            isUnique = true;
            for (MapEntryExpressionWrapper mapEntry : this.variableMaps.getMapEntryExpressions()) {
                if (!(mapEntry.getKeyExpression() instanceof ConstantExpressionWrapper) || !((String)newName).equals(((ConstantExpressionWrapper)mapEntry.getKeyExpression()).getValue())) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return newName;
            }
            newName = name + "_" + index;
            ++index;
        }
        return newName;
    }

    private boolean isObjectExpressionFindTestObjectMethodCall() {
        return this.objectExpressionWrapper instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)this.objectExpressionWrapper).isFindTestObjectMethodCall();
    }

    private void createOtherTypesTab(Composite parent) {
        this.otherTypesInputTableComposite = new Composite(parent, 0);
        this.otherTypesInputTableComposite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(this.otherTypesInputTableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.createTableColumns(parent);
        this.addSwitchTypeComboListener(parent);
    }

    private void addSwitchTypeComboListener(final Composite parent) {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TestObjectBuilderDialog.this.combo.getSelectionIndex();
                if (index < 0 || index >= TEST_OBJECT_TABS.length) {
                    return;
                }
                String tabName = TEST_OBJECT_TABS[index];
                ExpressionWrapper newExpression = null;
                if (tabName.equals(OBJECT_FINDER_TAB_NAME)) {
                    newExpression = (ExpressionWrapper)InputValueType.TestObject.getNewValue(TestObjectBuilderDialog.this.objectExpressionWrapper.getParent());
                    TestObjectBuilderDialog.this.stackLayout.topControl = TestObjectBuilderDialog.this.objectFinderComposite;
                } else {
                    newExpression = (ExpressionWrapper)defaultInputValueTypes[0].getNewValue(TestObjectBuilderDialog.this.objectExpressionWrapper.getParent());
                    TestObjectBuilderDialog.this.stackLayout.topControl = TestObjectBuilderDialog.this.otherTypesInputTableComposite;
                    TestObjectBuilderDialog.this.setSelectionResult(null);
                }
                newExpression.copyProperties(TestObjectBuilderDialog.this.objectExpressionWrapper);
                TestObjectBuilderDialog.this.objectExpressionWrapper = newExpression;
                TestObjectBuilderDialog.this.refresh();
                parent.layout();
            }
        });
    }

    private void createTableColumns(Composite parent) {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, defaultInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
                    return;
                }
                ASTNodeWrapper newAstNode = this.getNewAstNode(value, TestObjectBuilderDialog.this.objectExpressionWrapper);
                if (newAstNode == null || !(newAstNode instanceof ExpressionWrapper)) {
                    return;
                }
                newAstNode.copyProperties(TestObjectBuilderDialog.this.objectExpressionWrapper);
                TestObjectBuilderDialog.this.objectExpressionWrapper = (ExpressionWrapper)newAstNode;
                TestObjectBuilderDialog.this.refresh();
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }

    private static FolderTreeEntity createSelectedTreeEntityHierachy(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return null;
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)TestObjectBuilderDialog.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), rootFolder));
    }

    public void refresh() {
        if (!this.haveOtherTypes) {
            return;
        }
        ArrayList<ExpressionWrapper> objectExpressionWrapperList = new ArrayList<ExpressionWrapper>();
        objectExpressionWrapperList.add(this.objectExpressionWrapper);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(objectExpressionWrapperList);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnOK = this.createButton(parent, 102, IDialogConstants.OK_LABEL, true);
        btnOK.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestObjectBuilderDialog.this.okPressed();
                TestObjectBuilderDialog.this._instance.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void convertSelectionToObjectMethodCall() {
        if (!(this.getFirstResult() instanceof WebElementTreeEntity)) {
            return;
        }
        WebElementTreeEntity webElementTreeEntity = (WebElementTreeEntity)this.getFirstResult();
        String objectPk = null;
        try {
            if (!(webElementTreeEntity.getObject() instanceof WebElementEntity)) {
                return;
            }
            objectPk = ((WebElementEntity)webElementTreeEntity.getObject()).getIdForDisplay();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (objectPk == null) {
            return;
        }
        try {
            MethodCallExpressionWrapper newMethodCall;
            if ((WebElementEntity)webElementTreeEntity.getObject() instanceof WebServiceRequestEntity) {
                newMethodCall = this.convertRequestObjectSelectionToObjectMethodCall((WebServiceRequestEntity)webElementTreeEntity.getObject());
            } else {
                newMethodCall = AstEntityInputUtil.createNewFindTestObjectMethodCall(objectPk, this.objectExpressionWrapper.getParent());
                newMethodCall.copyProperties(this.objectExpressionWrapper);
                if (this.variableMaps != null && this.variableMaps.getMapEntryExpressions().size() > 0) {
                    newMethodCall.getArguments().addExpression(this.variableMaps);
                }
            }
            this.objectExpressionWrapper = newMethodCall;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MethodCallExpressionWrapper convertRequestObjectSelectionToObjectMethodCall(WebServiceRequestEntity requestEntity) {
        VariableEntity[] requestVariables;
        ExpressionWrapper secondParam;
        MethodCallExpressionWrapper methodCallExpression = (MethodCallExpressionWrapper)this.objectExpressionWrapper;
        MapExpressionWrapper variableMapExpression = methodCallExpression.getArguments().getExpressions().size() <= 1 ? new MapExpressionWrapper((ASTNodeWrapper)methodCallExpression.getArguments()) : (!((secondParam = methodCallExpression.getArguments().getExpressions().get(1)) instanceof MapExpressionWrapper) ? new MapExpressionWrapper((ASTNodeWrapper)methodCallExpression.getArguments()) : (MapExpressionWrapper)secondParam);
        MethodCallExpressionWrapper newMethodCallExpression = AstEntityInputUtil.createNewFindTestObjectMethodCall(requestEntity.getIdForDisplay(), this.objectExpressionWrapper.getParent());
        newMethodCallExpression.copyProperties(this.objectExpressionWrapper);
        variableMapExpression.clearExpressions();
        VariableEntity[] variableEntityArray = requestVariables = this.webServiceRequestVariablesPart.getVariables();
        int n = requestVariables.length;
        int n2 = 0;
        while (n2 < n) {
            VariableEntity variable = variableEntityArray[n2];
            MapEntryExpressionWrapper newMapEntry = new MapEntryExpressionWrapper((ASTNodeWrapper)variableMapExpression);
            newMapEntry.setKeyExpression(new ConstantExpressionWrapper(variable.getName(), (ASTNodeWrapper)newMapEntry));
            ExpressionWrapper valueExpression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(variable.getDefaultValue());
            newMapEntry.setValueExpression(valueExpression);
            variableMapExpression.addExpression(newMapEntry);
            ++n2;
        }
        if (variableMapExpression.getMapEntryExpressions().size() > 0) {
            newMethodCallExpression.getArguments().addExpression(variableMapExpression);
        }
        return newMethodCallExpression;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    @Override
    public ExpressionWrapper getReturnValue() {
        if (this.stackLayout.topControl == this.objectFinderComposite) {
            this.convertSelectionToObjectMethodCall();
        }
        return this.objectExpressionWrapper;
    }

    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_TEST_OBJ_INPUT;
    }

    private ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    protected void okPressed() {
        try {
            super.okPressed();
        }
        catch (Throwable throwable) {
            try {
                TestCasePreferenceDefaultValueInitializer.addRecentObject(ProjectController.getInstance().getCurrentProject(), (WebElementEntity)((WebElementTreeEntity)this.getFirstResult()).getObject());
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            TestCasePreferenceDefaultValueInitializer.addRecentObject(ProjectController.getInstance().getCurrentProject(), (WebElementEntity)((WebElementTreeEntity)this.getFirstResult()).getObject());
        }
        catch (Exception exception) {}
    }

    protected Point getInitialSize() {
        return new Point(super.getInitialSize().x, 700);
    }
}

