/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.dialogs.ApplyingEditingValue;
import com.kms.katalon.composer.testcase.groovy.ast.TokenWrapper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class OperationComboBoxCellEditor
extends ComboBoxCellEditor
implements ApplyingEditingValue {
    private TokenWrapper token;
    public static final int[] OPERATION_CODES = new int[]{123, 126, 124, 127, 125, 120, 164, 162, 100, 200, 201, 202, 203, 210, 211, 212, 213, 168, 166, 204, 205, 206, 214, 215, 216, 121, 122, 128, 280, 285, 281, 282, 286, 287};

    public OperationComboBoxCellEditor(Composite parent) {
        super(parent, new String[0]);
        String[] operationCodeStrings = new String[OPERATION_CODES.length];
        int i = 0;
        while (i < OPERATION_CODES.length) {
            operationCodeStrings[i] = Types.getText((int)OPERATION_CODES[i]);
            ++i;
        }
        this.setItems(operationCodeStrings);
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof TokenWrapper));
        this.token = ((TokenWrapper)value).clone();
        int index = 0;
        while (index < OPERATION_CODES.length) {
            if (OPERATION_CODES[index] == this.token.getType()) {
                super.doSetValue((Object)index);
                return;
            }
            ++index;
        }
        super.doSetValue((Object)0);
    }

    protected TokenWrapper doGetValue() {
        Integer selectionIndex = (Integer)super.doGetValue();
        if (selectionIndex < 0 || selectionIndex >= OPERATION_CODES.length) {
            return null;
        }
        this.token.setToken(Token.newSymbol((int)OPERATION_CODES[selectionIndex], (int)-1, (int)-1));
        return this.token;
    }

    public void applyEditingValue() {
        this.fireApplyEditorValue();
    }
}

