/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class DeleteVariableOperation
extends AbstractOperation {
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    private List<VariableEntity> variableList;
    private List<DeletedVariable> deletedVariableList;
    private List<DeletedVariableLink> deletedVariableLinkList;
    private TableViewer variableBindingTableViewer;
    private List<VariableLink> variableLinks;
    private TestCaseDataBindingPart dataBindingPart;

    public DeleteVariableOperation(TableActionOperator testCaseVariablePart) {
        super(DeleteVariableOperation.class.getName());
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
        this.deletedVariableList = new ArrayList<DeletedVariable>();
        if (testCaseVariablePart.getParent() != null) {
            this.deletedVariableLinkList = new ArrayList<DeletedVariableLink>();
            this.dataBindingPart = testCaseVariablePart.getParent().getDataBindingPart();
            this.variableBindingTableViewer = this.dataBindingPart.getVariableBindingTableViewer();
            this.variableLinks = this.dataBindingPart.getVariableLinkList();
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.deletedVariableList.clear();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Object[] selectionElements = selection.toArray();
        if (selectionElements.length == 0) {
            return Status.CANCEL_STATUS;
        }
        Object[] objectArray = selectionElements;
        int n = selectionElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof VariableEntity) {
                VariableEntity variable = (VariableEntity)object;
                int index = this.variableList.indexOf(variable);
                this.variableList.remove(index);
                this.deletedVariableList.add(new DeletedVariable(variable, index));
                if (this.deletedVariableLinkList != null) {
                    VariableLink variableLink = this.variableLinks.get(index);
                    this.variableLinks.remove(index);
                    this.deletedVariableLinkList.add(new DeletedVariableLink(variableLink, index));
                }
            }
            ++n2;
        }
        this.tableViewer.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.tableViewer.getTable().redraw();
        }
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int i = 0;
        while (i < this.deletedVariableList.size()) {
            this.variableList.remove(this.deletedVariableList.get(i).getVariable());
            this.variableLinks.remove(this.deletedVariableLinkList.get(i).getVariable());
            ++i;
        }
        this.tableViewer.refresh();
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<VariableEntity> undoElement = new ArrayList<VariableEntity>();
        int i = 0;
        while (i < this.deletedVariableList.size()) {
            DeletedVariable deletedVariable = this.deletedVariableList.get(i);
            VariableEntity variable = deletedVariable.getVariable();
            this.variableList.add(deletedVariable.getOriginalIndex(), variable);
            undoElement.add(variable);
            if (this.deletedVariableLinkList != null) {
                DeletedVariableLink deletedVariableLink = this.deletedVariableLinkList.get(i);
                this.variableLinks.add(deletedVariableLink.getOriginalIndex(), deletedVariableLink.getVariable());
            }
            ++i;
        }
        this.tableViewer.refresh();
        this.tableViewer.setSelection((ISelection)new StructuredSelection(undoElement.toArray()));
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    private void refreshVariableBindingTable() {
        if (this.dataBindingPart != null) {
            this.variableBindingTableViewer.refresh();
            this.variableBindingTableViewer.setInput(this.variableLinks);
            if (OSUtil.isMacBigSurOrLater()) {
                this.variableBindingTableViewer.getTable().redraw();
            }
        }
    }

    public class DeletedVariable {
        private VariableEntity variable;
        private int originalIndex;

        public DeletedVariable(VariableEntity variable, int originalIndex) {
            this.variable = variable;
            this.originalIndex = originalIndex;
        }

        public VariableEntity getVariable() {
            return this.variable;
        }

        public void setVariable(VariableEntity variable) {
            this.variable = variable;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public void setOriginalIndex(int originalIndex) {
            this.originalIndex = originalIndex;
        }
    }

    public class DeletedVariableLink {
        private VariableLink variable;
        private int originalIndex;

        public DeletedVariableLink(VariableLink variable, int originalIndex) {
            this.variable = variable;
            this.originalIndex = originalIndex;
        }

        public VariableLink getVariable() {
            return this.variable;
        }

        public void setVariable(VariableLink variable) {
            this.variable = variable;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public void setOriginalIndex(int originalIndex) {
            this.originalIndex = originalIndex;
        }
    }
}

