/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.util.CryptoUtil;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextEncryptionDialog
extends Dialog {
    private Text txtRawText;
    private Text txtEncryptedText;
    private String encryptedText;
    private Button btnInsert;
    private Button btnCopyAndClose;
    private Button btnCancel;
    private boolean isManualMode;

    private TextEncryptionDialog(Shell parentShell, boolean isManualMode) {
        super(parentShell);
        this.isManualMode = isManualMode;
    }

    public static TextEncryptionDialog createDialogForManualModeCellEditor(Shell parentShell) {
        return new TextEncryptionDialog(parentShell, true);
    }

    public static TextEncryptionDialog createDefault(Shell parentShell) {
        return new TextEncryptionDialog(parentShell, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData bodyGridData = new GridData(4, 4, true, true);
        bodyGridData.widthHint = 400;
        body.setLayoutData((Object)bodyGridData);
        body.setLayout((Layout)new GridLayout(1, false));
        Composite inputComposite = new Composite(body, 0);
        inputComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        inputComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblRawText = new Label(inputComposite, 0);
        lblRawText.setText(ComposerTestcaseMessageConstants.LBL_RAW_TEXT);
        this.txtRawText = new Text(inputComposite, 2048);
        this.txtRawText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblEncryptedText = new Label(inputComposite, 0);
        lblEncryptedText.setText(ComposerTestcaseMessageConstants.LBL_ENCRYPTED_TEXT);
        this.txtEncryptedText = new Text(inputComposite, 2048);
        this.txtEncryptedText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtEncryptedText.setEditable(false);
        Composite buttonComposite = new Composite(body, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 4, false, false));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        if (this.isManualMode) {
            this.btnInsert = new Button(buttonComposite, 0x800000);
            this.btnInsert.setText(ComposerTestcaseMessageConstants.BTN_INSERT);
            this.btnInsert.setEnabled(false);
        } else {
            this.btnCopyAndClose = new Button(buttonComposite, 0x800000);
            this.btnCopyAndClose.setText(ComposerTestcaseMessageConstants.BTN_COPY_AND_CLOSE);
            this.btnCopyAndClose.setEnabled(false);
        }
        this.btnCancel = new Button(buttonComposite, 0x800000);
        this.btnCancel.setText(ComposerTestcaseMessageConstants.BTN_CANCEL);
        this.addControlListeners();
        return body;
    }

    private void addControlListeners() {
        this.txtRawText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEncryptionDialog.this.handleGenerateEncryptedText();
                if (!StringUtils.isBlank((String)TextEncryptionDialog.this.encryptedText)) {
                    if (TextEncryptionDialog.this.isManualMode) {
                        TextEncryptionDialog.this.btnInsert.setEnabled(true);
                    } else {
                        TextEncryptionDialog.this.btnCopyAndClose.setEnabled(true);
                    }
                } else if (TextEncryptionDialog.this.isManualMode) {
                    TextEncryptionDialog.this.btnInsert.setEnabled(false);
                } else {
                    TextEncryptionDialog.this.btnCopyAndClose.setEnabled(false);
                }
            }
        });
        if (this.isManualMode) {
            this.btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextEncryptionDialog.this.handleGenerateEncryptedText();
                    TextEncryptionDialog.this.closeDialog();
                }
            });
        } else {
            this.btnCopyAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextEncryptionDialog.this.handleGenerateEncryptedText();
                    TextEncryptionDialog.this.handleCopyEncryptedText();
                    TextEncryptionDialog.this.closeDialog();
                }
            });
        }
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEncryptionDialog.this.cancelPressed();
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerTestcaseMessageConstants.DIA_TITLE_TEXT_ENCRYPTION);
    }

    private void handleGenerateEncryptedText() {
        String rawText = this.txtRawText.getText();
        if (!StringUtils.isEmpty((String)rawText)) {
            try {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)rawText);
                this.encryptedText = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
                this.txtEncryptedText.setText(this.encryptedText);
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else {
            this.txtEncryptedText.setText("");
            this.encryptedText = this.txtEncryptedText.getText();
        }
    }

    private void handleCopyEncryptedText() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{this.encryptedText}, new Transfer[]{textTransfer});
        clipboard.dispose();
    }

    private void closeDialog() {
        this.close();
    }

    public String getEncryptedText() {
        return this.encryptedText;
    }
}

