/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CallTestCaseCellEditor
extends AbstractDialogCellEditor {
    private String selectedTestCasePk;

    public CallTestCaseCellEditor(Composite parent, String defaultContent, String selectedTestCasePk) {
        super(parent, defaultContent);
        this.selectedTestCasePk = selectedTestCasePk;
    }

    protected void updateContents(Object value) {
        if (value instanceof TestCaseEntity) {
            try {
                super.updateContents((Object)((TestCaseEntity)value).getIdForDisplay());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (this.defaultContent != null) {
            super.updateContents((Object)this.defaultContent);
        } else {
            super.updateContents(value);
        }
    }

    private FolderTreeEntity createSelectedTreeEntityHierachy(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return null;
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)this.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), rootFolder));
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        try {
            EntityProvider entityProvider = new EntityProvider();
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
            dialog.setAllowMultiple(false);
            dialog.setTitle(ComposerTestcaseMessageConstants.EDI_TITLE_TEST_CASE_BROWSER);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject != null) {
                TestCaseEntity selectedTestCase;
                FolderEntity rootFolder = FolderController.getInstance().getTestCaseRoot(currentProject);
                dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
                if (this.selectedTestCasePk != null && (selectedTestCase = TestCaseController.getInstance().getTestCaseByDisplayId(this.selectedTestCasePk)) != null) {
                    dialog.setInitialSelection((Object)new TestCaseTreeEntity(selectedTestCase, (ITreeEntity)this.createSelectedTreeEntityHierachy(selectedTestCase.getParentFolder(), rootFolder)));
                }
            }
            if (dialog.open() == 0) {
                return dialog.getFirstResult();
            }
            return null;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.EDI_ERROR_MSG_CANNOT_OPEN_DIALOG);
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

