/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors.extensions;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.io.File;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class TestObjectsHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final String fArgument;
    private final String fName;
    private static final String WEBELEMENT_FILE_EXTENSION = ".rs";
    private static final String TESTCASE_FILE_EXTENSION = ".tc";
    private static final String DATA_FILE_EXTENSION = ".dat";
    private static final String WINDOWS_OBJECT_FILE_EXTENSION = ".wrs";

    public TestObjectsHyperlink(IRegion urlRegion, String functionName, String functionArgument) {
        this.fRegion = urlRegion;
        this.fName = functionName;
        this.fArgument = functionArgument;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        Object location = this.fArgument.replace("'", "");
        Object objectID = "";
        try {
            if (this.fName.contains("WindowsObject")) {
                location = ((String)location).startsWith("Object Repository") ? location : "Object Repository/" + (String)location;
                objectID = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + (String)location + WINDOWS_OBJECT_FILE_EXTENSION;
                WindowsElementEntity windowsElementEntity = WindowsElementController.getInstance().getWindowsElementEntity((String)objectID);
                EventBrokerSingleton.getInstance().getEventBroker().post("WINDOWS_TEST_OBJECT/OPEN", (Object)windowsElementEntity);
            } else if (this.fName.contains("TestObject")) {
                location = ((String)location).startsWith("Object Repository") ? location : "Object Repository/" + (String)location;
                objectID = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + (String)location + WEBELEMENT_FILE_EXTENSION;
                WebElementEntity entity = ObjectRepositoryController.getInstance().getWebElement((String)objectID);
                String event = entity instanceof MobileElementEntity ? "MOBILE_TESTOBJECT/OPEN" : (entity instanceof WebServiceRequestEntity ? "WSOBJECT/OPEN" : "TESTOBJECT/OPEN");
                EventBrokerSingleton.getInstance().getEventBroker().post(event, (Object)entity);
            } else if (this.fName.contains("TestCase")) {
                location = ((String)location).startsWith("Test Cases") ? location : "Test Cases/" + (String)location;
                objectID = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + (String)location + TESTCASE_FILE_EXTENSION;
                TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCase((String)objectID);
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/OPEN", (Object)testCaseEntity);
            } else if (this.fName.contains("TestData")) {
                location = ((String)location).startsWith("Data Files") ? location : "Data Files/" + (String)location;
                objectID = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + (String)location + DATA_FILE_EXTENSION;
                DataFileEntity testDataEntity = TestDataController.getInstance().getTestData((String)objectID);
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTDATA/OPEN", (Object)testDataEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.getInstance();
            LoggerSingleton.logError((String)e.getMessage());
        }
    }
}

