/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexLastStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CompositeStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;

public abstract class ComplexStatementWrapper<T extends ComplexChildStatementWrapper, U extends ComplexLastStatementWrapper>
extends StatementWrapper {
    protected List<T> complexChildStatements = new ArrayList<T>();
    protected U lastStatement = null;

    public ComplexStatementWrapper(StatementWrapper statementWrapper, ExpressionWrapper expression, BlockStatementWrapper block, ASTNodeWrapper parentNodeWrapper) {
        super(statementWrapper, parentNodeWrapper);
    }

    public ComplexStatementWrapper(Statement statement, ASTNodeWrapper parentNodeWrapper) {
        super(statement, parentNodeWrapper);
    }

    public ComplexStatementWrapper(ComplexStatementWrapper<T, U> complexStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(complexStatementWrapper, parentNodeWrapper);
        for (ComplexChildStatementWrapper complexChildStatement : complexStatementWrapper.getComplexChildStatements()) {
            this.complexChildStatements.add(this.copyChild((U)complexChildStatement));
        }
        if (complexStatementWrapper.hasLastStatement()) {
            this.lastStatement = this.copyChild(complexStatementWrapper.getLastStatement());
        }
    }

    public ComplexStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
    }

    public ComplexStatementWrapper() {
        this(null);
    }

    public T copyChild(T child) {
        return (T)((ComplexChildStatementWrapper)((CompositeStatementWrapper)child).copy(this));
    }

    public U copyChild(U child) {
        return (U)((ComplexLastStatementWrapper)child).copy(this);
    }

    public List<T> getComplexChildStatements() {
        return Collections.unmodifiableList(this.complexChildStatements);
    }

    public void addComplexChildStatement(T complexChildStatement) {
        if (complexChildStatement == null) {
            return;
        }
        ((ASTNodeWrapper)complexChildStatement).setParent(this);
        this.complexChildStatements.add(complexChildStatement);
    }

    public boolean addComplexChildStatement(T complexChildStatement, int index) {
        if (complexChildStatement == null || index < 0 || index > this.complexChildStatements.size()) {
            return false;
        }
        ((ASTNodeWrapper)complexChildStatement).setParent(this);
        this.complexChildStatements.add(index, complexChildStatement);
        return true;
    }

    public boolean removeComplexChildStatement(int index) {
        if (index < 0 || index >= this.complexChildStatements.size()) {
            return false;
        }
        this.complexChildStatements.remove(index);
        return true;
    }

    public boolean removeComplexChildStatement(T complexChildStatement) {
        return this.complexChildStatements.remove(complexChildStatement);
    }

    public int indexOf(T complexChildStatement) {
        return this.complexChildStatements.indexOf(complexChildStatement);
    }

    public boolean hasLastStatement() {
        return this.lastStatement != null;
    }

    public U getLastStatement() {
        return this.lastStatement;
    }

    public boolean setLastStatement(U lastStatement) {
        if (lastStatement == null || ((ASTNodeWrapper)lastStatement).isEqualsTo((ASTNodeWrapper)this.lastStatement)) {
            return false;
        }
        ((ASTNodeWrapper)lastStatement).setParent(this);
        this.lastStatement = lastStatement;
        return true;
    }

    public boolean removeLastStatement() {
        if (this.lastStatement == null) {
            return false;
        }
        this.lastStatement = null;
        return true;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<Object> astNodeWrappers = new ArrayList<Object>();
        astNodeWrappers.addAll(this.complexChildStatements);
        if (this.hasLastStatement()) {
            astNodeWrappers.add(this.lastStatement);
        }
        return astNodeWrappers;
    }
}

