/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CompositeStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ForStatementWrapper
extends CompositeStatementWrapper {
    private static final Class<?> DEFAULT_TYPE = Object.class;
    private static final String DEFAULT_VARIABLE_NAME = "index";
    private ParameterWrapper variable;
    private ExpressionWrapper collectionExpression;

    public ForStatementWrapper() {
        this(null);
    }

    public ForStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.variable = new ParameterWrapper(DEFAULT_TYPE, DEFAULT_VARIABLE_NAME, this);
        this.collectionExpression = new RangeExpressionWrapper(this);
    }

    public ForStatementWrapper(ForStatement forStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)forStatement, ForStatementWrapper.initLoopBlock(forStatement), parentNodeWrapper);
        this.variable = new ParameterWrapper(forStatement.getVariable(), (ASTNodeWrapper)this);
        this.collectionExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(forStatement.getCollectionExpression(), this);
    }

    private static BlockStatement initLoopBlock(ForStatement forStatement) {
        Statement loopBlock = forStatement.getLoopBlock();
        if (loopBlock instanceof BlockStatement) {
            return (BlockStatement)loopBlock;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(loopBlock);
        return block;
    }

    public ForStatementWrapper(ForStatementWrapper forStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(forStatementWrapper, parentNodeWrapper);
        this.variable = new ParameterWrapper(forStatementWrapper.getVariable(), (ASTNodeWrapper)this);
        this.collectionExpression = forStatementWrapper.getCollectionExpression().copy(this);
    }

    public ParameterWrapper getVariable() {
        return this.variable;
    }

    public void setVariable(ParameterWrapper variable) {
        if (variable == null) {
            return;
        }
        variable.setParent(this);
        this.variable = variable;
    }

    public ExpressionWrapper getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(ExpressionWrapper collectionExpression) {
        if (collectionExpression == null) {
            return;
        }
        collectionExpression.setParent(this);
        this.collectionExpression = collectionExpression;
    }

    @Override
    public String getText() {
        return "for (" + this.getInputText() + ")";
    }

    public static boolean isForLoopDummy(ParameterWrapper variable) {
        return variable.getType().getName().equals(ForStatement.FOR_LOOP_DUMMY.getType().getName()) && variable.getName().equals(ForStatement.FOR_LOOP_DUMMY.getName());
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.variable);
        astNodeWrappers.add(this.collectionExpression);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public ForStatementWrapper clone() {
        return new ForStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public String getInputText() {
        Object value = "";
        if (!(this.getCollectionExpression() instanceof ClosureListExpressionWrapper) && !ForStatementWrapper.isForLoopDummy(this.getVariable())) {
            value = (String)value + this.getVariable().getText();
            value = (String)value + " : ";
        }
        return (String)value + this.getCollectionExpression().getText();
    }

    @Override
    public ForStatementWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof ForStatementWrapper) || this.getVariable().isEqualsTo(((ForStatementWrapper)input).getVariable()) && this.getCollectionExpression().isEqualsTo(((ForStatementWrapper)input).getCollectionExpression())) {
            return false;
        }
        ForStatementWrapper newForStatement = (ForStatementWrapper)input;
        this.setVariable(newForStatement.getVariable());
        this.setCollectionExpression(newForStatement.getCollectionExpression());
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getCollectionExpression() && newChild instanceof ExpressionWrapper) {
            ExpressionWrapper newCollectionExpression = (ExpressionWrapper)newChild;
            ParameterWrapper variable = this.getVariable();
            if (newCollectionExpression instanceof ClosureListExpressionWrapper) {
                variable = new ParameterWrapper(ForStatement.FOR_LOOP_DUMMY, (ASTNodeWrapper)this);
            } else if (ForStatementWrapper.isForLoopDummy(variable)) {
                variable = new ParameterWrapper(Object.class, DEFAULT_VARIABLE_NAME, this);
            }
            variable.copyProperties(this.getVariable());
            this.setVariable(variable);
            this.setCollectionExpression(newCollectionExpression);
            return true;
        }
        if (oldChild == this.getVariable() && newChild instanceof ParameterWrapper) {
            this.setVariable((ParameterWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

