/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CaseStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DefaultStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;

public class SwitchStatementWrapper
extends ComplexStatementWrapper<CaseStatementWrapper, DefaultStatementWrapper> {
    private ExpressionWrapper expression;

    public SwitchStatementWrapper() {
        this(null);
    }

    public SwitchStatementWrapper(SwitchStatement switchStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)switchStatement, parentNodeWrapper);
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(switchStatement.getExpression(), this);
        for (CaseStatement caseStatement : switchStatement.getCaseStatements()) {
            this.complexChildStatements.add(new CaseStatementWrapper(caseStatement, this));
        }
        if (switchStatement.getDefaultStatement() instanceof BlockStatement) {
            this.lastStatement = new DefaultStatementWrapper((BlockStatement)switchStatement.getDefaultStatement(), this);
        }
    }

    public SwitchStatementWrapper(SwitchStatementWrapper switchStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(switchStatementWrapper, parentNodeWrapper);
        this.expression = switchStatementWrapper.getExpression().copy(this);
    }

    public SwitchStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(this);
        this.lastStatement = new DefaultStatementWrapper(this);
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.expression = expression;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("switch (");
        stringBuilder.append(this.getInputText());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.expression);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public SwitchStatementWrapper clone() {
        return new SwitchStatementWrapper(this, this.getParent());
    }

    @Override
    public SwitchStatementWrapper getInput() {
        return this;
    }

    @Override
    public String getInputText() {
        return this.getExpression().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof SwitchStatementWrapper && !this.getExpression().isEqualsTo(((SwitchStatementWrapper)input).getExpression())) {
            this.setExpression(((SwitchStatementWrapper)input).getExpression());
            return true;
        }
        return false;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper nodeWrapper) {
        return nodeWrapper instanceof CaseStatementWrapper || nodeWrapper instanceof DefaultStatementWrapper;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        if (childObject instanceof CaseStatementWrapper) {
            this.addComplexChildStatement((CaseStatementWrapper)childObject);
            return true;
        }
        if (childObject instanceof DefaultStatementWrapper) {
            return this.setLastStatement((DefaultStatementWrapper)childObject);
        }
        return false;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (childObject instanceof CaseStatementWrapper) {
            return this.addComplexChildStatement((CaseStatementWrapper)childObject, index);
        }
        if (childObject instanceof DefaultStatementWrapper) {
            return this.setLastStatement((DefaultStatementWrapper)childObject);
        }
        return false;
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        if (childObject instanceof CaseStatementWrapper) {
            return this.removeComplexChildStatement((CaseStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return this.removeLastStatement();
        }
        return false;
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        if (childObject instanceof CaseStatementWrapper) {
            return this.indexOf((CaseStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getExpression() && newChild instanceof ExpressionWrapper) {
            this.setExpression((ExpressionWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

