/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.model;

import com.kms.katalon.composer.testcase.model.InputParameter;
import java.util.ArrayList;
import java.util.List;

public class InputParameterBuilder {
    private final List<InputParameter> originalParameters;
    private final boolean testObjectParamIgnored;

    public List<InputParameter> getOriginalParameters() {
        return this.originalParameters;
    }

    private InputParameterBuilder(List<InputParameter> originalParameters, boolean testObjectParamIgnored) {
        this.originalParameters = originalParameters;
        this.testObjectParamIgnored = testObjectParamIgnored;
    }

    public static InputParameterBuilder createForMethodCall(List<InputParameter> inputParameters) {
        return new InputParameterBuilder(inputParameters, true);
    }

    public static InputParameterBuilder createForNestedMethodCall(List<InputParameter> inputParameters) {
        return new InputParameterBuilder(inputParameters, false);
    }

    public List<InputParameter> getFilteredInputParameters() {
        ArrayList<InputParameter> filteredInputParameters = new ArrayList<InputParameter>();
        boolean hasTestObjectParam = false;
        for (InputParameter inputParameter : this.originalParameters) {
            if (this.testObjectParamIgnored && inputParameter.isTestObjectInputParameter() && !hasTestObjectParam) {
                hasTestObjectParam = true;
                continue;
            }
            if (!inputParameter.isEditable()) continue;
            filteredInputParameters.add(inputParameter);
        }
        return filteredInputParameters;
    }
}

