/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.control.StyledTextMessage;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testcase.components.KeywordTreeViewerToolTipSupport;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.keywords.BuiltinKeywordFolderBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.CustomKeywordFolderBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserControlTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserFolderTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntityTransfer;
import com.kms.katalon.composer.testcase.providers.KeywordBrowserEntityViewerFilter;
import com.kms.katalon.composer.testcase.providers.KeywordTreeContentProvider;
import com.kms.katalon.composer.testcase.providers.KeywordTreeLabelProvider;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.custom.keyword.KeywordClass;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.event.EventHandler;

public class KeywordBrowserPart
implements EventHandler {
    private static final String SEARCH_TEXT_DEFAULT_VALUE = "Enter text to search...";
    private ToolItem tiRefresh;
    private TreeViewer treeViewer;
    private StyledText txtSearchInput;
    private KeywordTreeLabelProvider labelProvider;
    private KeywordBrowserEntityViewerFilter viewerFilter;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        this.createToolBar(mpart);
        this.createControls(parent);
        this.registerListerners();
        this.hookDoubleClickEvent();
        this.hookDragEvent();
        this.loadTreeData();
    }

    private void registerListerners() {
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("KEYWORD_BROWSER/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("CUSTOMKEYWORD/REFRESH", (EventHandler)this);
    }

    private void createToolBar(MPart part) {
        CTabFolder ctabfolder = (CTabFolder)part.getParent().getWidget();
        ToolBar toolbar = new ToolBar((Composite)ctabfolder, 0x800000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        MToolBar mToolbar = MMenuFactory.INSTANCE.createToolBar();
        mToolbar.setWidget((Object)toolbar);
        part.setToolbar(mToolbar);
        List toolItems = mToolbar.getChildren();
        MDirectToolItem mtiRefresh = MMenuFactory.INSTANCE.createDirectToolItem();
        toolItems.add(mtiRefresh);
        this.tiRefresh = new ToolItem(toolbar, 8);
        this.tiRefresh.setImage(ImageConstants.IMG_16_REFRESH);
        this.tiRefresh.setToolTipText(GlobalStringConstants.REFRESH);
        this.tiRefresh.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                KeywordBrowserPart.this.loadTreeData();
            }
        });
    }

    private void hookDoubleClickEvent() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() == null) {
                    return;
                }
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement == null || !(selectedElement instanceof KeywordBrowserFolderTreeEntity)) {
                    return;
                }
                KeywordTreeContentProvider contentProvider = (KeywordTreeContentProvider)KeywordBrowserPart.this.treeViewer.getContentProvider();
                if (contentProvider.hasChildren(selectedElement)) {
                    KeywordBrowserPart.this.treeViewer.setExpandedState(selectedElement, !KeywordBrowserPart.this.treeViewer.getExpandedState(selectedElement));
                }
            }
        });
    }

    private void hookDragEvent() {
        int operations = 7;
        DragSource dragSource = new DragSource((Control)this.treeViewer.getTree(), operations);
        dragSource.setTransfer(new Transfer[]{new KeywordBrowserTreeEntityTransfer()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                List<IKeywordBrowserTreeEntity> treeEntities = KeywordBrowserPart.this.getKeywordTreeEntityFromTree();
                event.doit = treeEntities.size() > 0;
            }

            public void dragSetData(DragSourceEvent event) {
                List<IKeywordBrowserTreeEntity> treeEntities = KeywordBrowserPart.this.getKeywordTreeEntityFromTree();
                if (treeEntities.size() > 0) {
                    event.data = treeEntities.toArray(new IKeywordBrowserTreeEntity[treeEntities.size()]);
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private List<IKeywordBrowserTreeEntity> getKeywordTreeEntityFromTree() {
        TreeItem[] selection = this.treeViewer.getTree().getSelection();
        ArrayList<IKeywordBrowserTreeEntity> treeEntities = new ArrayList<IKeywordBrowserTreeEntity>();
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof KeywordBrowserTreeEntity) {
                treeEntities.add((KeywordBrowserTreeEntity)item.getData());
            } else if (item.getData() instanceof KeywordBrowserControlTreeEntity) {
                treeEntities.add((KeywordBrowserControlTreeEntity)item.getData());
            }
            ++n2;
        }
        return treeEntities;
    }

    private void createControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(parent, 2048);
        searchComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glSearchComposite = new GridLayout(1, false);
        glSearchComposite.verticalSpacing = 0;
        glSearchComposite.horizontalSpacing = 0;
        glSearchComposite.marginWidth = 0;
        glSearchComposite.marginHeight = 0;
        searchComposite.setLayout((Layout)glSearchComposite);
        GridData grSearchComposite = new GridData(768);
        grSearchComposite.heightHint = 24;
        searchComposite.setLayoutData((Object)grSearchComposite);
        this.txtSearchInput = new StyledText(searchComposite, 4);
        this.txtSearchInput.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        StyledTextMessage styledTextMessage = new StyledTextMessage(this.txtSearchInput);
        styledTextMessage.setMessage(SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtSearchInput.setLayoutData((Object)gdTxtInput);
        this.txtSearchInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeywordBrowserPart.this.filterKeywordTreeEntitiesBySearchedText();
            }
        });
        this.txtSearchInput.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    KeywordBrowserPart.this.filterKeywordTreeEntitiesBySearchedText();
                }
            }
        });
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new KeywordTreeContentProvider());
        this.labelProvider = new KeywordTreeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewerFilter = new KeywordBrowserEntityViewerFilter();
        this.treeViewer.addFilter((ViewerFilter)this.viewerFilter);
        KeywordTreeViewerToolTipSupport.enableFor(this.treeViewer);
    }

    protected void filterKeywordTreeEntitiesBySearchedText() {
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        final String searchString = this.txtSearchInput.getText();
        while (this.treeViewer.isBusy()) {
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        try {
                            if (!searchString.equals(KeywordBrowserPart.this.txtSearchInput.getText()) || KeywordBrowserPart.this.treeViewer.getInput() == null) break block6;
                            KeywordBrowserPart.this.treeViewer.getTree().setRedraw(false);
                            KeywordBrowserPart.this.labelProvider.setSearchString(searchString);
                            KeywordBrowserPart.this.viewerFilter.setSearchString(searchString);
                            KeywordBrowserPart.this.treeViewer.refresh(true);
                            if (searchString != null && !searchString.isEmpty()) {
                                KeywordBrowserPart.this.treeViewer.expandAll();
                                break block6;
                            }
                            KeywordBrowserPart.this.treeViewer.collapseAll();
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                            KeywordBrowserPart.this.treeViewer.getTree().setRedraw(true);
                        }
                    }
                    finally {
                        KeywordBrowserPart.this.treeViewer.getTree().setRedraw(true);
                    }
                }
            }
        });
    }

    protected void loadTreeData() {
        KeywordBrowserFolderTreeEntity builtinKeywordRootFolder = KeywordBrowserPart.loadBuiltinKeywordFolderTreeEntity();
        CustomKeywordFolderBrowserTreeEntity customKeywordRootFolder = new CustomKeywordFolderBrowserTreeEntity(null);
        ArrayList<KeywordBrowserFolderTreeEntity> keywordTreeEntities = new ArrayList<KeywordBrowserFolderTreeEntity>();
        keywordTreeEntities.add(builtinKeywordRootFolder);
        keywordTreeEntities.add(customKeywordRootFolder);
        keywordTreeEntities.add(KeywordBrowserPart.loadControlKeywordFolderTreeEntity());
        this.treeViewer.setInput(keywordTreeEntities);
        this.treeViewer.refresh();
    }

    private static KeywordBrowserFolderTreeEntity loadBuiltinKeywordFolderTreeEntity() {
        ArrayList<IKeywordBrowserTreeEntity> keywordTreeEntities = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity builtinKeywordRootFolder = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.KEYWORD_BROWSER_BUILTIN_KEYWORD_ROOT_TREE_ITEM_LABEL, null, keywordTreeEntities);
        for (KeywordClass builtInKeywordContributor : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            keywordTreeEntities.add(new BuiltinKeywordFolderBrowserTreeEntity(builtInKeywordContributor.getName(), builtInKeywordContributor.getSimpleName(), builtInKeywordContributor.getLabelName(), builtinKeywordRootFolder));
        }
        return builtinKeywordRootFolder;
    }

    private static KeywordBrowserFolderTreeEntity loadControlKeywordFolderTreeEntity() {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.KEYWORD_BROWSER_CONTROL_KEYWORD_ROOT_TREE_ITEM_LABEL, null, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(70, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_CALL_TEST_CASE, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadDecisionMakingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadLoopingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadBranchingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadExceptionHandlingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(6, ComposerTestcaseMessageConstants.TREE_BINARY_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(7, ComposerTestcaseMessageConstants.TREE_ASSERT_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(8, ComposerTestcaseMessageConstants.TREE_METHOD_CALL_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(72, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_METHOD, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadDecisionMakingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_DECISION_MAKING_STATEMENT, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(1, ComposerTestcaseMessageConstants.TREE_IF_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(2, ComposerTestcaseMessageConstants.TREE_ELSE_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(3, ComposerTestcaseMessageConstants.TREE_ELSE_IF_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(12, ComposerTestcaseMessageConstants.TREE_SWITCH_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(13, ComposerTestcaseMessageConstants.TREE_CASE_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(14, ComposerTestcaseMessageConstants.TREE_DEFAULT_STATEMENT, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadLoopingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_LOOPING_STATEMENT, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(5, ComposerTestcaseMessageConstants.TREE_FOR_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(4, ComposerTestcaseMessageConstants.TREE_WHILE_STATEMENT, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadBranchingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_BRANCHING_STATEMENT, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(9, ComposerTestcaseMessageConstants.TREE_BREAK_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(10, ComposerTestcaseMessageConstants.TREE_CONTINUE_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(11, ComposerTestcaseMessageConstants.TREE_RETURN_STATEMENT, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadExceptionHandlingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_EXCEPTION_HANDLING_STATEMENT, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(15, ComposerTestcaseMessageConstants.TREE_TRY_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(16, ComposerTestcaseMessageConstants.TREE_CATCH_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(17, ComposerTestcaseMessageConstants.TREE_FINALLY_STATEMENT, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(18, ComposerTestcaseMessageConstants.TREE_THROW_STATEMENT, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private void refreshCustomKeywordFolder() {
        List keywordTreeEntities = (List)this.treeViewer.getInput();
        int keywordTreeEntitiesSize = keywordTreeEntities.size();
        this.treeViewer.getTree().setRedraw(false);
        int i = 0;
        while (i < keywordTreeEntitiesSize) {
            KeywordBrowserFolderTreeEntity keywordTreeEntity;
            if (keywordTreeEntities.get(i) instanceof KeywordBrowserFolderTreeEntity && (keywordTreeEntity = (KeywordBrowserFolderTreeEntity)keywordTreeEntities.get(i)).getName().equals(ComposerTestcaseMessageConstants.KEYWORD_BROWSER_CUSTOM_KEYWORD_ROOT_TREE_ITEM_LABEL)) {
                keywordTreeEntities.set(i, new CustomKeywordFolderBrowserTreeEntity(null));
                boolean isExpanded = this.treeViewer.getTree().getItem(i).getExpanded();
                KeywordTreeContentProvider contentProvider = (KeywordTreeContentProvider)this.treeViewer.getContentProvider();
                this.treeViewer.refresh(true);
                if (!contentProvider.hasChildren(keywordTreeEntity)) break;
                List newKeywordTreeEntities = (List)this.treeViewer.getInput();
                this.treeViewer.setExpandedState(newKeywordTreeEntities.get(i), isExpanded);
                break;
            }
            ++i;
        }
        this.treeViewer.getTree().setRedraw(true);
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (event.getTopic().equals("PROJECT/OPENED") || event.getTopic().equals("KEYWORD_BROWSER/REFRESH")) {
            this.loadTreeData();
        }
        if (event.getTopic().equals("CUSTOMKEYWORD/REFRESH")) {
            this.refreshCustomKeywordFolder();
        }
    }
}

