/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.MenuUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCallTestCaseKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCustomKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePartDataBindingView;
import com.kms.katalon.composer.testcase.parts.TestStepManualComposite;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.ITestCaseDataProvider;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.events.TestDataUpdatedEvent;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import com.kms.katalon.entity.variable.VariableEntity;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestCasePart
extends CPart
implements EventHandler,
ITestCasePart {
    private TestStepManualComposite testStepManualComposite;
    private MPart mPart;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private TestCaseCompositePart parentTestCaseCompositePart;
    private TestCasePartDataBindingView childrenView;
    private boolean scriptLoaded = false;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mPart = mpart;
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof TestCaseCompositePart) {
            this.parentTestCaseCompositePart = (TestCaseCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.registerEventBrokerListeners();
        this.createControls(parent);
    }

    public MPart getMPart() {
        return this.mPart;
    }

    @Focus
    public void setFocus() {
        this.testStepManualComposite.setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
        this.setDirty(false);
    }

    private void registerEventBrokerListeners() {
        this.eventBroker.subscribe("TESTCASE/FAILURE_HANDLING_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTCASE/ADD_STEP", (EventHandler)this);
        this.eventBroker.subscribe("TESTCASE/ADD_STEP/CALL_TESTCASE", (EventHandler)this);
        this.eventBroker.subscribe("TESTDATA/UPDATE", (EventHandler)this);
        this.eventBroker.subscribe("TESTOBJECT/UPDATED", (EventHandler)this);
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        this.testStepManualComposite = TestStepManualComposite.newInstance(this, parent, this.parentTestCaseCompositePart);
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (this.mPart != null) {
            this.mPart.setDirty(isDirty);
        }
        this.parentTestCaseCompositePart.updateDirty();
    }

    public boolean isManualScriptChanged() {
        if (this.getTreeTableInput() != null) {
            return this.getTreeTableInput().isChanged();
        }
        return false;
    }

    public void setManualScriptChanged(boolean change) {
        if (this.getTreeTableInput() != null) {
            this.getTreeTableInput().setChanged(change);
        }
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "TESTCASE/FAILURE_HANDLING_UPDATED": {
                try {
                    if (this.getTreeTableInput() != null) {
                        this.loadASTNodesToTreeTable(this.getTreeTableInput().getMainClassNode());
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                return;
            }
            case "TESTCASE/ADD_STEP": {
                Object eventData = EventUtil.getData((Event)event);
                if (this.isInvalidTargetPart(eventData)) {
                    return;
                }
                this.switchToManualView();
                Object actionId = ((Object[])eventData)[1];
                this.testStepManualComposite.addStepByActionID((Integer)actionId);
                return;
            }
            case "TESTCASE/ADD_STEP/CALL_TESTCASE": {
                Object eventData = EventUtil.getData((Event)event);
                if (this.isInvalidTargetPart(eventData)) {
                    return;
                }
                Object testcase = ((Object[])eventData)[1];
                if (!(testcase instanceof TestCaseEntity)) {
                    return;
                }
                this.switchToManualView();
                this.testStepManualComposite.addCallTestCaseStep((TestCaseEntity)testcase);
                return;
            }
            case "TESTDATA/UPDATE": {
                try {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object == null) {
                        return;
                    }
                    if (!(object instanceof TestDataUpdatedEvent)) break;
                    TestDataUpdatedEvent eventData = (TestDataUpdatedEvent)object;
                    String oldTestDataPk = eventData.getOriginalPk();
                    DataFileEntity newTestData = eventData.getDataFileEntity();
                    String projectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                    String oldTestDataId = TestDataController.getInstance().getTestDataDisplayIdByPk(oldTestDataPk, projectLocation);
                    String newTestDataId = TestDataController.getInstance().getTestDataDisplayIdByPk(newTestData.getId(), projectLocation);
                    this.parentTestCaseCompositePart.refreshTestCaseAfterTestDataChanged(oldTestDataId, newTestDataId);
                    if (!eventData.shouldTriggerReferenceUpdate()) break;
                    this.parentTestCaseCompositePart.saveTestCase(ITestCaseDataProvider.ReferenceUpdateOption.KEEP_REFERENCE);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                break;
            }
            case "TESTOBJECT/UPDATED": {
                try {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object == null) {
                        return;
                    }
                    if (!(object instanceof TestObjectUpdatedEvent)) break;
                    TestObjectUpdatedEvent eventData = (TestObjectUpdatedEvent)object;
                    String oldTestObjectPk = eventData.getOriginalPk();
                    WebElementEntity newTestObject = eventData.getWebElementEntity();
                    String projectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                    String oldTestObjectId = ObjectRepositoryController.getInstance().getTestObjectDisplayIdByPk(oldTestObjectPk, projectLocation);
                    String newTestObjectId = ObjectRepositoryController.getInstance().getTestObjectDisplayIdByPk(newTestObject.getId(), projectLocation);
                    this.parentTestCaseCompositePart.refreshTestCaseAfterTestDataChanged(oldTestObjectId, newTestObjectId);
                    if (!eventData.shouldTriggerReferenceUpdate()) break;
                    this.parentTestCaseCompositePart.saveTestCase(ITestCaseDataProvider.ReferenceUpdateOption.KEEP_REFERENCE);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                break;
            }
        }
    }

    private void switchToManualView() {
        if (this.mPart.equals(this.parentTestCaseCompositePart.getSelectedPart())) {
            return;
        }
        this.parentTestCaseCompositePart.setSelectedPart(this.mPart);
    }

    private boolean isInvalidTargetPart(Object eventData) {
        return !eventData.getClass().isArray() || ((Object[])eventData).length != 2 || !this.mPart.getElementId().startsWith((String)((Object[])eventData)[0]);
    }

    @Persist
    public boolean doSave() {
        try {
            this.parentTestCaseCompositePart.save();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public void clearAndAddStatementsToMainBlock(List<StatementWrapper> statements, TestCaseTreeTableInput.NodeAddType addType, boolean commitEditting) {
        this.getTreeTableInput().getMainClassNode().getRunMethod().getBlock().clearStaments();
        this.getTreeTableInput().getMainClassNode().getRunMethod().getBlock().addStatements(statements);
        if (commitEditting) {
            this.getTestCaseTreeTable().applyEditorValue();
        }
        try {
            this.getTreeTableInput().reloadTreeTableNodes();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void addStatementsToMainBlock(List<StatementWrapper> statements, TestCaseTreeTableInput.NodeAddType addType, boolean commitEditting) {
        this.getTreeTableInput().getMainClassNode().getRunMethod().getBlock().addStatements(statements);
        if (commitEditting) {
            this.getTestCaseTreeTable().applyEditorValue();
        }
        try {
            this.getTreeTableInput().reloadTreeTableNodes();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void clearStatements() {
        this.getTreeTableInput().getMainClassNode().getRunMethod().getBlock().clearStaments();
        try {
            this.getTreeTableInput().reloadTreeTableNodes();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void addStatements(List<StatementWrapper> statements, TestCaseTreeTableInput.NodeAddType addType) {
        this.getTreeTableInput().addNewAstObjects(statements, this.getTreeTableInput().getSelectedNode(), addType);
    }

    public void addStatements(List<StatementWrapper> statements, TestCaseTreeTableInput.NodeAddType addType, boolean commitEditting) {
        this.getTreeTableInput().addNewAstObjects(statements, this.getTreeTableInput().getSelectedNode(), addType);
        if (commitEditting) {
            this.getTestCaseTreeTable().applyEditorValue();
        }
    }

    @Override
    public TestCaseEntity getTestCase() {
        return this.parentTestCaseCompositePart.getTestCase();
    }

    @Override
    public TestCaseTreeTableInput getTreeTableInput() {
        return this.testStepManualComposite.getTreeTableInput();
    }

    @Override
    public void addVariables(VariableEntity[] variables) {
        this.parentTestCaseCompositePart.addVariables(variables);
    }

    @Override
    public void deleteVariables(List<VariableEntity> variables) {
        this.parentTestCaseCompositePart.deleteVariables(variables);
    }

    @Override
    public VariableEntity[] getVariables() {
        return this.parentTestCaseCompositePart.getVariables();
    }

    public void addDefaultImports() {
        this.getTreeTableInput().addDefaultImports();
    }

    public void addImports(List<ImportNodeWrapper> imports) {
        this.getTreeTableInput().addImports(imports);
    }

    public TreeViewer getTestCaseTreeTable() {
        return this.testStepManualComposite.getTreeTable();
    }

    @Override
    public List<AstTreeTableNode> getDragNodes() {
        return this.testStepManualComposite.getDragNodes();
    }

    public void loadASTNodesToTreeTable(ScriptNodeWrapper scriptNode) {
        this.scriptLoaded = true;
        this.testStepManualComposite.loadASTNodesToTreeTable(scriptNode);
    }

    public boolean isTestCaseEmpty() {
        TreeItem[] treeItemArray = this.getTestCaseTreeTable().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getText().matches("\\d+.*")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<String> getCommentSteps() {
        return Arrays.asList(this.getTestCaseTreeTable().getTree().getItems()).stream().filter(item -> item.getText(0).contains(GlobalMessageConstants.COMMENT)).map(item -> this.getCommentText(item.getText(2))).collect(Collectors.toList());
    }

    private String getCommentText(String comment) {
        String doubleQuote = "\"";
        comment = StringUtils.removeStart((String)comment, (String)doubleQuote);
        comment = StringUtils.removeEnd((String)comment, (String)doubleQuote);
        return comment;
    }

    @Override
    public void createDynamicGotoMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        ControlUtils.removeOldOpenMenuItem((Menu)menu);
        IStructuredSelection selection = this.testStepManualComposite.getTreeTableSelection();
        if (selection.size() == 0) {
            return;
        }
        List<FileEntity> testObjects = this.getListTestObjectFromSelection(selection);
        if (testObjects.size() == 0) {
            return;
        }
        SelectionAdapter openTestCase = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = e.getSource();
                if (!(object instanceof MenuItem)) {
                    return;
                }
                TestCaseEntity testCaseEntity = TestCasePart.this.getTestCaseFromMenuItem((MenuItem)object);
                if (testCaseEntity != null) {
                    TestCasePart.this.eventBroker.send("TESTCASE/OPEN", (Object)testCaseEntity);
                }
            }
        };
        SelectionAdapter openTestObject = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = e.getSource();
                if (!(object instanceof MenuItem)) {
                    return;
                }
                FileEntity webElementEntity = TestCasePart.this.getWebElementFromMenuItem((MenuItem)object);
                if (webElementEntity == null) {
                    return;
                }
                String openEventName = "";
                if (webElementEntity instanceof WebServiceRequestEntity) {
                    openEventName = "WSOBJECT/OPEN";
                } else if (webElementEntity instanceof MobileElementEntity) {
                    openEventName = "MOBILE_TESTOBJECT/OPEN";
                } else if (webElementEntity instanceof WindowsElementEntity) {
                    openEventName = "WINDOWS_TEST_OBJECT/OPEN";
                } else if (webElementEntity instanceof WebElementEntity) {
                    openEventName = "TESTOBJECT/OPEN";
                }
                TestCasePart.this.eventBroker.post(openEventName, (Object)webElementEntity);
            }
        };
        new MenuItem(menu, 2);
        if (testObjects.size() == 1) {
            this.handleWhenSelectOnlyOne(menu, testObjects.get(0), openTestCase, openTestObject);
            return;
        }
        MenuUtils.createOpenTestArtifactsMenu(this.getMapFileEntityToSelectionAdapter(testObjects, openTestCase, openTestObject), (Menu)menu);
    }

    private void handleWhenSelectOnlyOne(Menu menu, FileEntity entity, SelectionAdapter openTestCaseAdapter, SelectionAdapter openTestObjectAdapter) {
        String name = ComposerTestcaseMessageConstants.MENU_OPEN + " " + entity.getName();
        if (entity instanceof TestCaseEntity) {
            ControlUtils.createSubMenuOpen((Menu)menu, (FileEntity)entity, (SelectionAdapter)openTestCaseAdapter, (String)name);
        } else if (entity instanceof WebElementEntity || entity instanceof WindowsElementEntity) {
            ControlUtils.createSubMenuOpen((Menu)menu, (FileEntity)entity, (SelectionAdapter)openTestObjectAdapter, (String)name);
        }
    }

    private FileEntity getTestObjectFromMethod(AstAbstractKeywordTreeTableNode node) {
        Object findTestObjectMethodCall = node.getTestObject();
        if (!(findTestObjectMethodCall instanceof MethodCallExpressionWrapper)) {
            return null;
        }
        String testObjectId = AstEntityInputUtil.findTestObjectIdFromFindTestObjectMethodCall((MethodCallExpressionWrapper)findTestObjectMethodCall);
        if (testObjectId != null) {
            try {
                return ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        testObjectId = AstEntityInputUtil.findWindowsTestObjectIdFromFindTestObjectMethodCall((MethodCallExpressionWrapper)findTestObjectMethodCall);
        if (testObjectId != null) {
            try {
                return WindowsElementController.getInstance().getWindowsElementByDisplayId(testObjectId);
            }
            catch (ControllerException controllerException) {
                return null;
            }
        }
        return null;
    }

    private FileEntity getWebElementFromMenuItem(MenuItem menuItem) {
        FileEntity webElementEntity = null;
        if (menuItem.getData() instanceof FileEntity) {
            webElementEntity = (FileEntity)menuItem.getData();
        }
        return webElementEntity;
    }

    private TestCaseEntity getTestCaseFromMenuItem(MenuItem menuItem) {
        TestCaseEntity testCaseEntity = null;
        if (menuItem.getData() instanceof TestCaseEntity) {
            testCaseEntity = (TestCaseEntity)menuItem.getData();
        }
        return testCaseEntity;
    }

    private List<FileEntity> getListTestObjectFromSelection(IStructuredSelection selection) {
        ArrayList<FileEntity> testObjects = new ArrayList<FileEntity>();
        for (Object object : selection.toList()) {
            TestCaseEntity testObject;
            if (object instanceof AstCallTestCaseKeywordTreeTableNode) {
                testObject = ((AstCallTestCaseKeywordTreeTableNode)object).getTestObject();
                if (testObject == null || testObjects.contains(testObject)) continue;
                testObjects.add((FileEntity)testObject);
                continue;
            }
            if (object instanceof AstBuiltInKeywordTreeTableNode) {
                testObject = this.getTestObjectFromMethod((AstBuiltInKeywordTreeTableNode)object);
                if (testObject == null || testObjects.contains(testObject)) continue;
                testObjects.add((FileEntity)testObject);
                continue;
            }
            if (!(object instanceof AstCustomKeywordTreeTableNode) || (testObject = this.getTestObjectFromMethod((AstCustomKeywordTreeTableNode)object)) == null || testObjects.contains(testObject)) continue;
            testObjects.add((FileEntity)testObject);
        }
        return testObjects;
    }

    private HashMap<FileEntity, SelectionAdapter> getMapFileEntityToSelectionAdapter(List<? extends FileEntity> fileEntities, SelectionAdapter openTestCase, SelectionAdapter openTestObject) {
        HashMap<FileEntity, SelectionAdapter> map = new HashMap<FileEntity, SelectionAdapter>();
        for (FileEntity fileEntity : fileEntities) {
            if (fileEntity instanceof TestCaseEntity) {
                map.put(fileEntity, openTestCase);
                continue;
            }
            if (fileEntity instanceof WebElementEntity) {
                map.put(fileEntity, openTestObject);
                continue;
            }
            if (!(fileEntity instanceof WindowsElementEntity)) continue;
            map.put(fileEntity, openTestObject);
        }
        return map;
    }

    public boolean isScriptLoaded() {
        return this.scriptLoaded;
    }
}

