/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts.decoration;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.parts.decoration.DecoratedKeyword;
import com.kms.katalon.composer.testcase.preferences.StoredKeyword;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import org.eclipse.swt.graphics.Image;

public class KeywordDecorationService {
    public static DecoratedKeyword getDecoratedKeyword(StoredKeyword storedKeyword) {
        if (storedKeyword.isCustom()) {
            return new DecoratedCustomKeyword(storedKeyword);
        }
        return new DecoratedBuiltinKeyword(storedKeyword);
    }

    public static class DecoratedBuiltinKeyword
    implements DecoratedKeyword {
        private StoredKeyword storedKeyword;

        public DecoratedBuiltinKeyword(StoredKeyword storedKeyword) {
            this.storedKeyword = storedKeyword;
        }

        @Override
        public Image getImage() {
            switch (this.getKeywordContributor().getAliasName()) {
                case "WebUI": {
                    return ImageConstants.IMG_16_WEB_UI;
                }
                case "Mobile": {
                    return ImageConstants.IMG_16_MOBILE;
                }
                case "WS": {
                    return ImageConstants.IMG_16_WS;
                }
                case "CucumberKW": {
                    return ImageConstants.IMG_16_CUCUMBER;
                }
            }
            return null;
        }

        @Override
        public String getLabel() {
            return TreeEntityUtil.getReadableKeywordName((String)this.storedKeyword.getKeywordName());
        }

        @Override
        public String getTooltip() {
            return String.format("%s (%s)", this.getLabel(), this.getKeywordContributor().getLabelName());
        }

        private IKeywordContributor getKeywordContributor() {
            return KeywordContributorCollection.getContributor((String)this.storedKeyword.getKeywordClass());
        }

        @Override
        public ExpressionStatementWrapper newStep(ASTNodeWrapper parentNode) {
            return AstKeywordsInputUtil.createBuiltInKeywordStatement(this.getKeywordContributor().getAliasName(), this.storedKeyword.getKeywordName(), parentNode);
        }
    }

    public static class DecoratedCustomKeyword
    implements DecoratedKeyword {
        private StoredKeyword storedKeyword;

        public DecoratedCustomKeyword(StoredKeyword storedKeyword) {
            this.storedKeyword = storedKeyword;
        }

        @Override
        public Image getImage() {
            return ImageConstants.IMG_16_CUSTOM;
        }

        @Override
        public String getLabel() {
            return this.storedKeyword.getKeywordName();
        }

        @Override
        public String getTooltip() {
            return String.format("%s (%s)", this.getLabel(), "Custom Keyword");
        }

        @Override
        public ExpressionStatementWrapper newStep(ASTNodeWrapper parentNode) {
            return AstKeywordsInputUtil.createNewCustomKeywordStatement(this.storedKeyword.getKeywordClass(), this.storedKeyword.getKeywordName(), parentNode);
        }
    }
}

