/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserControlTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

public class KeywordTreeLabelProvider
extends StyledCellLabelProvider
implements IEntityLabelProvider {
    private String searchString = null;

    public String getText(Object element) {
        if (element instanceof IKeywordBrowserTreeEntity) {
            if (element instanceof KeywordBrowserTreeEntity && !((KeywordBrowserTreeEntity)element).isCustom()) {
                return TreeEntityUtil.getReadableKeywordName((String)((IKeywordBrowserTreeEntity)element).getName());
            }
            return ((IKeywordBrowserTreeEntity)element).getName();
        }
        return GlobalMessageConstants.EMPTY;
    }

    public String getToolTipText(Object element) {
        if (element instanceof IKeywordBrowserTreeEntity) {
            return ((IKeywordBrowserTreeEntity)element).getToolTip();
        }
        return GlobalMessageConstants.EMPTY;
    }

    public Image getImage(Object element) {
        if (element instanceof KeywordBrowserTreeEntity || element instanceof KeywordBrowserControlTreeEntity) {
            return ImageConstants.IMG_16_KEYWORD;
        }
        return ImageConstants.IMG_16_FOLDER;
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getText(cell.getElement()));
        ArrayList<StyleRange> range = new ArrayList<StyleRange>();
        if (this.searchString != null && !this.searchString.equals("")) {
            this.searchString = this.searchString.toLowerCase();
            if (cell.getText().toLowerCase().contains(this.searchString) && !this.searchString.isEmpty()) {
                Matcher m = Pattern.compile(this.searchString).matcher(cell.getText().toLowerCase());
                while (m.find()) {
                    StyleRange myStyledRange = new StyleRange(m.start(), this.searchString.length(), null, ColorUtil.getHighlightBackgroundColor());
                    range.add(myStyledRange);
                }
            }
        }
        cell.setStyleRanges(range.toArray(new StyleRange[range.size()]));
        cell.setImage(this.getImage(cell.getElement()));
        super.update(cell);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    protected void measure(Event event, Object element) {
        super.measure(event, element);
        ++event.width;
    }
}

