/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.parts.TestCasePartDataBindingView;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;

public class VariableTableLabelProvider
extends TypeCheckedStyleCellLabelProvider<VariableLink> {
    public static final int COLUMN_NOTIFICATION_INDEX = 0;
    public static final int COLUMN_NO_INDEX = 1;
    public static final int COLUMN_NAME_INDEX = 2;
    public static final int COLUMN_DEFAULT_VALUE_INDEX = 3;
    public static final int COLUMN_TYPE_INDEX = 4;
    public static final int COLUMN_TEST_DATA_ID_INDEX = 5;
    public static final int COLUMN_VALUE_INDEX = 6;
    private static TestCaseController testCaseController = TestCaseController.getInstance();
    private int columnIndex;
    private TestCasePartDataBindingView testCaseDataBindingView;

    public VariableTableLabelProvider(int columnIndex, TestCasePartDataBindingView testDataTreeView) {
        super(columnIndex);
        this.columnIndex = columnIndex;
        this.testCaseDataBindingView = testDataTreeView;
    }

    protected Class<VariableLink> getElementType() {
        return VariableLink.class;
    }

    protected Image getImage(VariableLink variableLink) {
        VariableLink.VariableType type = variableLink.getType();
        if (type == VariableLink.VariableType.DEFAULT || type == VariableLink.VariableType.SCRIPT_VARIABLE) {
            return null;
        }
        switch (this.columnIndex) {
            case 0: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId()) || StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ImageConstants.IMG_16_ERROR_TABLE_ITEM;
                }
                return null;
            }
            case 5: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    return ImageConstants.IMG_16_WARN_TABLE_ITEM;
                }
                return null;
            }
            case 6: {
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ImageConstants.IMG_16_WARN_TABLE_ITEM;
                }
                return null;
            }
        }
        return null;
    }

    private VariableEntity getVariableEntity(String variableLinkId) {
        for (VariableEntity entity : this.testCaseDataBindingView.getVariablesList()) {
            if (!entity.getId().equals(variableLinkId)) continue;
            return entity;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getText(VariableLink variableLink) {
        TestCaseEntity testCase = this.testCaseDataBindingView.getSelectedTestCaseLink();
        if (testCase == null) {
            return "";
        }
        try {
            VariableEntity variableEntity = this.getVariableEntity(variableLink.getVariableId());
            if (variableEntity == null) {
                return "";
            }
            switch (this.columnIndex) {
                case 1: {
                    return Integer.toString(this.testCaseDataBindingView.getListVariableLink().indexOf(variableLink) + 1);
                }
                case 2: {
                    return variableEntity.getName();
                }
                case 3: {
                    return variableEntity.getDefaultValue();
                }
                case 4: {
                    return variableLink.getType().toString();
                }
                case 5: {
                    if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                        return "";
                    }
                    TestCaseTestDataLink testDataLink = this.getTestCaseTestDataLink(variableLink.getTestDataLinkId());
                    if (testDataLink == null) {
                        return "";
                    }
                    int order = this.testCaseDataBindingView.getTestCaseTestDataLinks().indexOf(testDataLink) + 1;
                    return Integer.toString(order) + " - " + testDataLink.getTestDataId();
                }
                case 6: {
                    if (variableLink.getType() == VariableLink.VariableType.DEFAULT) {
                        return "";
                    }
                    String string = variableLink.getValue();
                    return string;
                }
            }
            return "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return "";
    }

    private TestCaseTestDataLink getTestCaseTestDataLink(String id) {
        for (TestCaseTestDataLink link : this.testCaseDataBindingView.getTestCaseTestDataLinks()) {
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    protected String getElementToolTipText(VariableLink variableLink) {
        VariableLink.VariableType type = variableLink.getType();
        if (type == VariableLink.VariableType.DEFAULT || type == VariableLink.VariableType.SCRIPT_VARIABLE) {
            return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
        }
        switch (this.columnIndex) {
            case 0: {
                String variableType = variableLink.getType().toString();
                if (StringUtils.equals((String)VariableLink.VariableType.SCRIPT_VARIABLE.toString(), (String)variableType) || StringUtils.equals((String)VariableLink.VariableType.DEFAULT.toString(), (String)variableType)) {
                    return null;
                }
                StringBuilder tooltipText = new StringBuilder();
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    tooltipText.append(ComposerTestcaseMessageConstants.LP_WARN_MSG_SET_TEST_DATA_NOTIFY);
                }
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    if (tooltipText.length() != 0) {
                        tooltipText.append("\n");
                    }
                    tooltipText.append(ComposerTestcaseMessageConstants.LP_WARN_MSG_SET_TEST_DATA_COLUMN_NOTIFY);
                }
                return StringUtils.defaultIfEmpty((String)tooltipText.toString(), null);
            }
            case 5: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    return ComposerTestcaseMessageConstants.LP_WARN_MSG_SET_TEST_DATA;
                }
                return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
            }
            case 6: {
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ComposerTestcaseMessageConstants.LP_WARN_MSG_SET_TEST_DATA_COLUMN;
                }
                return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
            }
        }
        return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
    }
}

