/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.testcase.ast.treetable.AstStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstInputEditableNode;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.util.WrapperToAstTreeConverter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class InputColumnEditingSupport
extends TypeCheckedEditingSupport<IAstInputEditableNode> {
    private ITestCasePart parentTestCasePart;

    public InputColumnEditingSupport(TreeViewer viewer, ITestCasePart parentTestCasePart) {
        super((ColumnViewer)viewer);
        this.parentTestCasePart = parentTestCasePart;
    }

    protected Class<IAstInputEditableNode> getElementType() {
        return IAstInputEditableNode.class;
    }

    protected CellEditor getCellEditorByElement(IAstInputEditableNode element) {
        return element.getCellEditorForInput(this.getComposite());
    }

    protected boolean canEditElement(IAstInputEditableNode element) {
        return element.canEditInput();
    }

    protected Object getElementValue(IAstInputEditableNode element) {
        return element.getInput();
    }

    protected void setElementValue(IAstInputEditableNode element, Object value) {
        new OperationExecutor((Object)this.parentTestCasePart).executeOperation((IUndoableOperation)new NodeItemValueChangeOperation(element, value));
    }

    private class NodeItemValueChangeOperation
    extends AbstractOperation {
        private IAstInputEditableNode node;
        private Object value;
        private Object oldValue;

        public NodeItemValueChangeOperation(IAstInputEditableNode node, Object value) {
            super(NodeItemValueChangeOperation.class.getName());
            this.node = node;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.node.getInput();
            if (this.oldValue instanceof ASTNodeWrapper) {
                this.oldValue = ((ASTNodeWrapper)this.oldValue).clone();
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetInputValue(this.value);
        }

        protected IStatus doSetInputValue(Object inputValue) {
            if (!this.node.setInput(inputValue)) {
                return Status.CANCEL_STATUS;
            }
            TestCaseTreeTableInput treeTableInput = InputColumnEditingSupport.this.parentTestCasePart.getTreeTableInput();
            treeTableInput.setDirty(true);
            InputColumnEditingSupport.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.node));
            if (this.isNodeTransformed(this.node, inputValue)) {
                this.reloadTableIfNodeTransformed(this.node, treeTableInput);
                return Status.OK_STATUS;
            }
            treeTableInput.refresh(this.node);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetInputValue(this.oldValue);
        }

        private void reloadTableIfNodeTransformed(IAstInputEditableNode element, TestCaseTreeTableInput treeTableInput) {
            AstTreeTableNode parentNode = ((AstTreeTableNode)((Object)element)).getParent();
            if (parentNode != null) {
                treeTableInput.refresh(parentNode);
                return;
            }
            try {
                treeTableInput.reloadTreeTableNodes();
            }
            catch (InterruptedException | InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }

        private boolean isNodeTransformed(IAstInputEditableNode element, Object value) {
            if (!(element instanceof AstStatementTreeTableNode)) {
                return false;
            }
            AstStatementTreeTableNode statementTreeTableNode = (AstStatementTreeTableNode)((Object)element);
            List<AstTreeTableNode> newNodes = WrapperToAstTreeConverter.getInstance().convert(Arrays.asList(statementTreeTableNode.getASTObject()), statementTreeTableNode);
            if (newNodes.size() != 1) {
                return true;
            }
            AstTreeTableNode newElementNode = newNodes.get(0);
            return !element.equals(newElementNode) || !element.getClass().equals(newElementNode.getClass());
        }
    }
}

