/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.factory;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.factory.ICapabilityHandlerFactory;
import com.katalon.capability.handler.ICapabilityHandler;
import com.katalon.capability.handler.impl.AndroidCapabilityHandler;
import com.katalon.capability.handler.impl.ChromeCapabilityHandler;
import com.katalon.capability.handler.impl.ChromeHeadlessCapabilityHandler;
import com.katalon.capability.handler.impl.EdgeChromiumCapabilityHandler;
import com.katalon.capability.handler.impl.FirefoxCapabilityHandler;
import com.katalon.capability.handler.impl.FirefoxHeadlessCapabilityHandler;
import com.katalon.capability.handler.impl.IOSCapabilityHandler;
import com.katalon.capability.handler.impl.KobitonCapabilityHandler;
import com.katalon.capability.handler.impl.RemoteCapabilityHandler;
import com.katalon.capability.handler.impl.SafariCapabilityHandler;
import com.katalon.capability.handler.impl.TestCloudCapabilityHandler;
import com.katalon.capability.handler.impl.WindowsCapabilityHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CapabilityHandlerFactoryImpl
implements ICapabilityHandlerFactory {
    private final IEclipseContext eclipseContext;

    @Inject
    public CapabilityHandlerFactoryImpl(IEclipseContext eclipseContext) {
        this.eclipseContext = eclipseContext;
    }

    @Override
    public ICapabilityHandler getCapabilityHandler(DriverType driverType) throws UnsupportedDriverTypeException {
        return switch (driverType) {
            case DriverType.CHROME_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(ChromeCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.EDGE_CHROMIUM_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(EdgeChromiumCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.FIREFOX_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(FirefoxCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.SAFARI_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(SafariCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.HEADLESS_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(ChromeHeadlessCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.FIREFOX_HEADLESS_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(FirefoxHeadlessCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.REMOTE_WEB_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(RemoteCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.ANDROID_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(AndroidCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.IOS_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(IOSCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.WINDOWS_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(WindowsCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.KOBITON_WEB_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(KobitonCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            case DriverType.TESTCLOUD_DRIVER -> (ICapabilityHandler)ContextInjectionFactory.make(TestCloudCapabilityHandler.class, (IEclipseContext)this.eclipseContext);
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

