/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.core.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminJwtToken {
    private static final Logger logger = LoggerFactory.getLogger(AdminJwtToken.class);
    private Long exp;
    private String katOneJwt;
    private String userName;

    public static AdminJwtToken parseToken(String token) {
        if (token == null || token.isEmpty()) {
            logger.warn("Token is null or empty!");
            return null;
        }
        String[] chunk = token.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(chunk[1]));
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (AdminJwtToken)mapper.readValue(payload, AdminJwtToken.class);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse token!", (Throwable)e);
            return null;
        }
    }

    public Long getExp() {
        return this.exp;
    }

    public String getKatOneJwt() {
        return this.katOneJwt;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isExpired() {
        return this.exp <= Instant.now().getEpochSecond();
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public void setKatOneJwt(String katOneJwt) {
        this.katOneJwt = katOneJwt;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

