/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal.event;

import com.katalon.platform.api.event.EventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventListernerDelegate
implements EventListener,
EventHandler {
    private final Map<Class, List<Consumer>> consumerLookup = new HashMap<Class, List<Consumer>>();
    private final EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            try {
                EventListernerDelegate.this.handleEvent(event);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    };

    public EventListernerDelegate(String pluginId) {
    }

    public final void handleEvent(Event event) {
        List<Consumer> consumers = this.consumerLookup.get(Event.class);
        consumers.stream().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public <T> void on(Class<T> eventType, Consumer<T> consumer) {
        List<Consumer> consumers = this.consumerLookup.get(eventType);
        if (consumers == null) {
            consumers = new ArrayList<Consumer>();
            this.consumerLookup.put(eventType, consumers);
        }
        consumers.add(consumer);
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }
}

