/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXTargetDependency
implements Comparable<PBXTargetDependency> {
    private CommentedIdentifier reference;
    private String isa;
    private CommentedIdentifier target;
    private CommentedIdentifier targetProxy;

    public PBXTargetDependency(String targetDependencyString) throws InvalidObjectFormatException {
        try {
            targetDependencyString = targetDependencyString.trim();
            int equalsIndex = targetDependencyString.indexOf(61);
            String commentPart = "";
            String uuidPart = targetDependencyString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = targetDependencyString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(targetDependencyString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("target")) {
                    this.target = parser.getCommentedIdentifier(value);
                } else if (key.equals("targetProxy")) {
                    this.targetProxy = parser.getCommentedIdentifier(value);
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        returnString = returnString + tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        returnString = returnString + tabString + "\ttarget = " + this.target.toString() + ";\n";
        returnString = returnString + tabString + "\ttargetProxy = " + this.targetProxy.toString() + ";\n";
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(PBXTargetDependency o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public CommentedIdentifier getTarget() {
        return this.target;
    }

    public CommentedIdentifier getTargetProxy() {
        return this.targetProxy;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setTarget(CommentedIdentifier target) {
        this.target = target;
    }

    public void setTargetProxy(CommentedIdentifier targetProxy) {
        this.targetProxy = targetProxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PBXTargetDependency)) {
            return false;
        }
        PBXTargetDependency other = (PBXTargetDependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        CommentedIdentifier this$target = this.getTarget();
        CommentedIdentifier other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        CommentedIdentifier this$targetProxy = this.getTargetProxy();
        CommentedIdentifier other$targetProxy = other.getTargetProxy();
        return !(this$targetProxy == null ? other$targetProxy != null : !((Object)this$targetProxy).equals(other$targetProxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PBXTargetDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        CommentedIdentifier $target = this.getTarget();
        result = result * 59 + ($target == null ? 0 : ((Object)$target).hashCode());
        CommentedIdentifier $targetProxy = this.getTargetProxy();
        result = result * 59 + ($targetProxy == null ? 0 : ((Object)$targetProxy).hashCode());
        return result;
    }

    public PBXTargetDependency() {
    }

    @ConstructorProperties(value={"reference", "isa", "target", "targetProxy"})
    public PBXTargetDependency(CommentedIdentifier reference, String isa, CommentedIdentifier target, CommentedIdentifier targetProxy) {
        this.reference = reference;
        this.isa = isa;
        this.target = target;
        this.targetProxy = targetProxy;
    }
}

