/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class GherkinTagRule
implements IRule {
    private IToken token;

    public GherkinTagRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int column = scanner.getColumn();
        if (column >= 1) {
            scanner.unread();
            int pc = scanner.read();
            if (!Character.isWhitespace(pc)) {
                return Token.UNDEFINED;
            }
        }
        int c = scanner.read();
        int count = 1;
        if (c == 64) {
            while (c != -1) {
                if (c == 64 && count > 1 || Character.isWhitespace(c)) {
                    scanner.unread();
                    --count;
                    break;
                }
                ++count;
                c = scanner.read();
            }
            if (count > 2) {
                return this.token;
            }
        }
        int i = 0;
        while (i < count) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }
}

