/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.editors.MatchResultPair;
import cucumber.eclipse.editor.preferences.ICucumberPreferenceConstants;
import gherkin.formatter.AnsiFormats;
import gherkin.formatter.Argument;
import gherkin.formatter.Format;
import gherkin.formatter.Formats;
import gherkin.formatter.Formatter;
import gherkin.formatter.MonochromeFormats;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.StepPrinter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.CellResult;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DescribedStatement;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrettyFormatter
implements Reporter,
Formatter {
    private final StepPrinter stepPrinter = new StepPrinter();
    private final NiceAppendable out;
    private final boolean executing;
    private final Formats formats;
    private final boolean rightAlignNumeric;
    private final boolean centerSteps;
    private final boolean preserveBlankLineBetweenSteps;
    private final String indent;
    private String uri;
    private Mapper<Tag, String> tagNameMapper = new Mapper<Tag, String>(){

        public String map(Tag tag) {
            return tag.getName();
        }
    };
    private Match match;
    private int[][] cellLengths;
    private int[] maxLengths;
    private int rowIndex;
    private List<? extends Row> rows;
    private Integer rowHeight = null;
    private boolean rowsAbove = false;
    private List<Step> steps = new ArrayList<Step>();
    private List<Integer> indentations = new ArrayList<Integer>();
    private List<MatchResultPair> matchesAndResults = new ArrayList<MatchResultPair>();
    private DescribedStatement statement;
    private int centerSteps_maxKeywordLength;
    private int expectedNextStepLine;
    private static final Pattern LEADING_WS = Pattern.compile("^[\t ]+");
    private static final Pattern START = Pattern.compile("^", 8);
    private static final Pattern TRIPLE_QUOTES = Pattern.compile("\"\"\"", 8);
    private static final String ESCAPED_TRIPLE_QUOTES = "\\\\\"\\\\\"\\\\\"";

    private PrettyFormatter(Builder builder) {
        this.out = new NiceAppendable(builder.out);
        this.executing = builder.executing;
        this.formats = builder.monochrome ? new MonochromeFormats() : new AnsiFormats();
        this.rightAlignNumeric = builder.rightAlignNumeric;
        this.centerSteps = builder.centerSteps;
        this.preserveBlankLineBetweenSteps = builder.preserveBlankLineBetweenSteps;
        this.indent = builder.indentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
        this.printComments(feature.getComments(), "");
        this.printTags(feature.getTags(), "");
        this.out.println((CharSequence)(String.valueOf(feature.getKeyword()) + ": " + feature.getName()));
        this.printDescription(feature.getDescription(), this.indent, false);
    }

    public void background(Background background) {
        this.replay();
        this.statement = background;
    }

    public void scenario(Scenario scenario) {
        this.replay();
        this.statement = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.replay();
        this.statement = scenarioOutline;
    }

    private void replay() {
        this.addAnyOrphanMatch();
        this.printStatement();
        this.printSteps();
    }

    private void printSteps() {
        if (this.centerSteps) {
            this.centerSteps_maxKeywordLength = 0;
            for (Step step : this.steps) {
                int length = step.getKeyword().length();
                if (length <= this.centerSteps_maxKeywordLength) continue;
                this.centerSteps_maxKeywordLength = length;
            }
        }
        if (this.preserveBlankLineBetweenSteps) {
            this.expectedNextStepLine = 0;
        }
        while (!this.steps.isEmpty()) {
            if (this.matchesAndResults.isEmpty()) {
                this.printStep("skipped", Collections.emptyList(), null);
                continue;
            }
            MatchResultPair matchAndResult = this.matchesAndResults.remove(0);
            this.printStep(matchAndResult.getResultStatus(), matchAndResult.getMatchArguments(), matchAndResult.getMatchLocation());
            if (!matchAndResult.hasResultErrorMessage()) continue;
            this.printError(matchAndResult.result);
        }
    }

    private void printStatement() {
        if (this.statement == null) {
            return;
        }
        this.calculateLocationIndentations();
        this.out.println();
        this.printComments(this.statement.getComments(), this.indent);
        if (this.statement instanceof TagStatement) {
            this.printTags(((TagStatement)this.statement).getTags(), this.indent);
        }
        StringBuilder buffer = new StringBuilder(this.indent);
        buffer.append(this.statement.getKeyword());
        buffer.append(": ");
        buffer.append(this.statement.getName());
        String location = this.executing ? String.valueOf(this.uri) + ":" + this.statement.getLine() : null;
        buffer.append(this.indentedLocation(location));
        this.out.println((CharSequence)buffer);
        this.printDescription(this.statement.getDescription(), String.valueOf(this.indent) + this.indent, true);
        this.statement = null;
    }

    private String indentedLocation(String location) {
        int indentation;
        StringBuilder sb = new StringBuilder();
        int n = indentation = this.indentations.isEmpty() ? 0 : this.indentations.remove(0);
        if (location == null) {
            return "";
        }
        int i = 0;
        while (i < indentation) {
            sb.append(' ');
            ++i;
        }
        sb.append(' ');
        sb.append(this.getFormat("comment").text("# " + location));
        return sb.toString();
    }

    public void examples(Examples examples) {
        this.replay();
        this.out.println();
        this.printComments(examples.getComments(), String.valueOf(this.indent) + this.indent);
        this.printTags(examples.getTags(), String.valueOf(this.indent) + this.indent);
        this.out.println((CharSequence)(String.valueOf(this.indent) + this.indent + examples.getKeyword() + ": " + examples.getName()));
        this.printDescription(examples.getDescription(), String.valueOf(this.indent) + this.indent + this.indent, true);
        this.table(examples.getRows());
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    public void match(Match match) {
        this.addAnyOrphanMatch();
        this.match = match;
    }

    private void addAnyOrphanMatch() {
        if (this.match != null) {
            this.matchesAndResults.add(new MatchResultPair(this.match, null));
        }
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
        this.out.println((CharSequence)this.getFormat("output").text(text));
    }

    public void result(Result result) {
        this.matchesAndResults.add(new MatchResultPair(this.match, result));
        this.match = null;
    }

    public void before(Match match, Result result) {
        this.printHookFailure(match, result, true);
    }

    public void after(Match match, Result result) {
        this.printHookFailure(match, result, false);
    }

    private void printHookFailure(Match match, Result result, boolean isBefore) {
        if (result.getStatus().equals("failed")) {
            Format format = this.getFormat(result.getStatus());
            StringBuffer context = new StringBuffer("Failure in ");
            if (isBefore) {
                context.append("before");
            } else {
                context.append("after");
            }
            context.append(" hook:");
            this.out.println((CharSequence)(String.valueOf(format.text(context.toString())) + format.text(match.getLocation())));
            this.out.println((CharSequence)(String.valueOf(format.text("Message: ")) + format.text(result.getErrorMessage())));
            if (result.getError() != null) {
                this.printError(result);
            }
        }
    }

    private void printStep(String status, List<Argument> arguments, String location) {
        Step step = this.steps.remove(0);
        Format textFormat = this.getFormat(status);
        Format argFormat = this.getArgFormat(status);
        List comments = step.getComments();
        if (this.preserveBlankLineBetweenSteps) {
            int expectedStepLine;
            int line = step.getLine();
            if (this.expectedNextStepLine > 0 && line > (expectedStepLine = this.expectedNextStepLine + comments.size())) {
                this.out.println();
            }
            this.expectedNextStepLine = line + 1;
            if (step.getRows() != null) {
                this.expectedNextStepLine += step.getRows().size();
            } else if (step.getDocString() != null) {
                this.expectedNextStepLine = step.getDocString().getLineRange().getLast() + 1;
            }
        }
        this.printComments(comments, String.valueOf(this.indent) + this.indent);
        StringBuilder buffer = new StringBuilder(String.valueOf(this.indent) + this.indent);
        String keyword = step.getKeyword();
        if (this.centerSteps) {
            int padLeft = this.centerSteps_maxKeywordLength - keyword.length();
            int i = 0;
            while (i < padLeft) {
                buffer.append(" ");
                ++i;
            }
        }
        buffer.append(textFormat.text(keyword));
        this.stepPrinter.writeStep(new NiceAppendable((Appendable)buffer), textFormat, argFormat, step.getName(), arguments);
        buffer.append(this.indentedLocation(location));
        this.out.println((CharSequence)buffer);
        if (step.getRows() != null) {
            this.table(step.getRows());
        } else if (step.getDocString() != null) {
            this.docString(step.getDocString());
        }
    }

    private Format getFormat(String key) {
        return this.formats.get(key);
    }

    private Format getArgFormat(String key) {
        return this.formats.get(String.valueOf(key) + "_arg");
    }

    public void table(List<? extends Row> rows) {
        this.prepareTable(rows);
        if (!this.executing) {
            for (Row row : rows) {
                this.row(row.createResults("skipped"));
                this.nextRow();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareTable(List<? extends Row> rows) {
        void var3_6;
        this.rows = rows;
        int columnCount = 0;
        for (Row row : rows) {
            if (columnCount >= row.getCells().size()) continue;
            columnCount = row.getCells().size();
        }
        this.cellLengths = new int[rows.size()][columnCount];
        this.maxLengths = new int[columnCount];
        boolean bl = false;
        while (var3_6 < rows.size()) {
            Row row = rows.get((int)var3_6);
            List cells = row.getCells();
            int colIndex = 0;
            while (colIndex < columnCount) {
                int length;
                String cell = this.getCellSafely(cells, colIndex);
                this.cellLengths[var3_6][colIndex] = length = this.escapeCell(cell).length();
                this.maxLengths[colIndex] = Math.max(this.maxLengths[colIndex], length);
                ++colIndex;
            }
            ++var3_6;
        }
        this.rowIndex = 0;
    }

    private String getCellSafely(List<String> cells, int colIndex) {
        return colIndex < cells.size() ? cells.get(colIndex) : "";
    }

    public void row(List<CellResult> cellResults) {
        StringBuilder buffer = new StringBuilder();
        Row row = this.rows.get(this.rowIndex);
        if (this.rowsAbove) {
            buffer.append(this.formats.up(this.rowHeight.intValue()));
        } else {
            this.rowsAbove = true;
        }
        this.rowHeight = 1;
        for (Comment comment : row.getComments()) {
            buffer.append(String.valueOf(this.indent) + this.indent + this.indent);
            buffer.append(comment.getValue());
            buffer.append("\n");
            this.rowHeight = this.rowHeight + 1;
        }
        switch (row.getDiffType()) {
            case NONE: {
                buffer.append(String.valueOf(this.indent) + this.indent + this.indent + "| ");
                break;
            }
            case DELETE: {
                buffer.append(String.valueOf(this.indent) + this.indent).append(this.formats.get("skipped").text("-")).append(" | ");
                break;
            }
            case INSERT: {
                buffer.append(String.valueOf(this.indent) + this.indent).append(this.formats.get("comment").text("+")).append(" | ");
            }
        }
        int colIndex = 0;
        while (colIndex < this.maxLengths.length) {
            boolean rightAligned;
            String cellText = this.escapeCell(this.getCellSafely(row.getCells(), colIndex));
            String status = null;
            switch (row.getDiffType()) {
                case NONE: {
                    status = cellResults.size() < colIndex ? cellResults.get(colIndex).getStatus() : "skipped";
                    break;
                }
                case DELETE: {
                    status = "skipped";
                    break;
                }
                case INSERT: {
                    status = "comment";
                }
            }
            Format format = this.formats.get(status);
            int padding = this.maxLengths[colIndex] - this.cellLengths[this.rowIndex][colIndex];
            boolean bl = rightAligned = this.rightAlignNumeric && PrettyFormatter.isNumeric(cellText);
            if (rightAligned) {
                this.padSpace(buffer, padding);
            }
            buffer.append(format.text(cellText));
            if (!rightAligned) {
                this.padSpace(buffer, padding);
            }
            if (colIndex < this.maxLengths.length - 1) {
                buffer.append(" | ");
            } else {
                buffer.append(" |");
            }
            ++colIndex;
        }
        this.out.println((CharSequence)buffer);
        this.rowHeight = this.rowHeight + 1;
        HashSet<Result> seenResults = new HashSet<Result>();
        for (CellResult cellResult : cellResults) {
            for (Result result : cellResult.getResults()) {
                if (result.getErrorMessage() == null || seenResults.contains(result)) continue;
                this.printError(result);
                this.rowHeight = this.rowHeight + result.getErrorMessage().split("\n").length;
                seenResults.add(result);
            }
        }
    }

    public static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    private void printError(Result result) {
        Format failed = this.formats.get("failed");
        this.out.println((CharSequence)PrettyFormatter.indent(failed.text(result.getErrorMessage()), String.valueOf(this.indent) + this.indent + this.indent));
    }

    public void nextRow() {
        ++this.rowIndex;
        this.rowsAbove = false;
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        throw new UnsupportedOperationException();
    }

    public void done() {
    }

    public void close() {
        this.out.close();
    }

    private String escapeCell(String cell) {
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    public void docString(DocString docString) {
        this.out.println((CharSequence)(String.valueOf(this.indent) + this.indent + this.indent + "\"\"\""));
        this.out.println((CharSequence)PrettyFormatter.escapeTripleQuotes(PrettyFormatter.indent(docString.getValue(), String.valueOf(this.indent) + this.indent + this.indent)));
        this.out.println((CharSequence)(String.valueOf(this.indent) + this.indent + this.indent + "\"\"\""));
    }

    public void eof() {
        this.replay();
    }

    private void calculateLocationIndentations() {
        int[] lineWidths = new int[this.steps.size() + 1];
        int i = 0;
        ArrayList<Object> statements = new ArrayList<Object>();
        statements.add(this.statement);
        statements.addAll(this.steps);
        int maxLineWidth = 0;
        for (BasicStatement basicStatement : statements) {
            int stepWidth = basicStatement.getKeyword().length() + basicStatement.getName().length();
            lineWidths[i++] = stepWidth;
            maxLineWidth = Math.max(maxLineWidth, stepWidth);
        }
        int[] nArray = lineWidths;
        int n = lineWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.indentations.add(maxLineWidth - n3);
            ++n2;
        }
    }

    private void padSpace(StringBuilder buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(" ");
            ++i;
        }
    }

    private void printComments(List<Comment> comments, String indent) {
        for (Comment comment : comments) {
            this.out.println((CharSequence)(String.valueOf(indent) + comment.getValue()));
        }
    }

    private void printTags(List<Tag> tags, String indent) {
        if (tags.isEmpty()) {
            return;
        }
        this.out.println((CharSequence)(String.valueOf(indent) + FixJava.join((List)FixJava.map(tags, this.tagNameMapper), (String)" ")));
    }

    private void printDescription(String description, String indentation, boolean newline) {
        if (!"".equals(description)) {
            if (ICucumberPreferenceConstants.CucumberIndentationStyle.FOUR_SPACES.getValue().equals(this.indent)) {
                description = this.trimLeadingWhitespace(description);
            }
            this.out.println((CharSequence)PrettyFormatter.indent(description, indentation));
            if (newline) {
                this.out.println();
            }
        }
    }

    private String trimLeadingWhitespace(String description) {
        Scanner scanner = new Scanner(description);
        int minCharCount = this.getLeadingWhitespace(scanner.nextLine()).length();
        while (scanner.hasNextLine()) {
            int charCount = this.getLeadingWhitespace(scanner.nextLine()).length();
            if (minCharCount <= charCount) continue;
            minCharCount = charCount;
        }
        scanner.close();
        if (minCharCount > 0) {
            return Pattern.compile("^[\t ]{" + minCharCount + "}", 8).matcher(description).replaceAll("");
        }
        return description;
    }

    private String getLeadingWhitespace(String str) {
        Matcher m = LEADING_WS.matcher(str);
        return m.find() ? m.group(0) : "";
    }

    private static String indent(String s, String indentation) {
        return START.matcher(s).replaceAll(indentation);
    }

    private static String escapeTripleQuotes(String s) {
        return TRIPLE_QUOTES.matcher(s).replaceAll(ESCAPED_TRIPLE_QUOTES);
    }

    public void endOfScenarioLifeCycle(Scenario arg0) {
    }

    public void startOfScenarioLifeCycle(Scenario arg0) {
    }

    public static class Builder {
        private Appendable out;
        private boolean monochrome;
        private boolean executing;
        private boolean rightAlignNumeric;
        private boolean centerSteps;
        private boolean preserveBlankLineBetweenSteps;
        private String indentation;

        public Builder output(Appendable out) {
            this.out = out;
            return this;
        }

        public Builder monochrome(boolean monochrome) {
            this.monochrome = monochrome;
            return this;
        }

        public Builder executing(boolean executing) {
            this.executing = executing;
            return this;
        }

        public Builder rightAlignNumeric(boolean rightAlignNumeric) {
            this.rightAlignNumeric = rightAlignNumeric;
            return this;
        }

        public Builder centerSteps(boolean centerSteps) {
            this.centerSteps = centerSteps;
            return this;
        }

        public Builder preserveBlankLineBetweenSteps(boolean preserveBlankLineBetweenSteps) {
            this.preserveBlankLineBetweenSteps = preserveBlankLineBetweenSteps;
            return this;
        }

        public Builder indentation(String indentation) {
            this.indentation = indentation;
            return this;
        }

        public PrettyFormatter build() {
            return new PrettyFormatter(this);
        }
    }
}

