/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.handler;

import cucumber.eclipse.editor.controller.CucumberController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class OnFileChangeListener
implements IResourceChangeListener {
    private String projectPath;
    private static Job currentJob;
    private static Map<String, IResourceDelta> deltasInQueue;

    static {
        deltasInQueue = new ConcurrentHashMap<String, IResourceDelta>();
    }

    public OnFileChangeListener(String projectPath) {
        this.projectPath = projectPath;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        IResourceDelta child = delta.findMember((IPath)new Path(this.projectPath));
        if (child != null) {
            this.triggerBuildOnAffectedFiles(child);
        }
    }

    private void triggerBuildOnAffectedFiles(IResourceDelta delta) {
        IResourceDelta[] children = delta.getAffectedChildren();
        String deltaFilePath = delta.getFullPath().toOSString();
        if (children.length <= 0 && deltaFilePath.contains("Include")) {
            deltasInQueue.put(deltaFilePath, delta);
            if (currentJob != null && currentJob.getState() == 4) {
                return;
            }
            currentJob = this.incrementalBuildJob(delta);
            currentJob.schedule();
            return;
        }
        IResourceDelta[] iResourceDeltaArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.triggerBuildOnAffectedFiles(child);
            ++n2;
        }
    }

    private Job incrementalBuildJob(IResourceDelta delta) {
        return new Job("Incremental cucumber loading..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (deltasInQueue.size() > 0) {
                    Map.Entry<String, IResourceDelta> entry = deltasInQueue.entrySet().iterator().next();
                    try {
                        try {
                            new CucumberController().incrementalBuild(entry.getValue(), monitor);
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, "cucumber.eclipse.editor.builder", "Unable to load Cucumber scripts");
                            deltasInQueue.remove(entry.getKey());
                            return status;
                        }
                    }
                    finally {
                        deltasInQueue.remove(entry.getKey());
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }
}

